/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.ion;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.persist.ion.IONArtifact;
import com.ibm.neo.persist.ion.IONObject;
import java.io.IOException;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IONIncTimestamp
implements IONArtifact {
    private final int mTime;
    private final int mInc;
    public static final String ION_INC_TS_TYPE = "$timestamp";
    public static final String FIELD_T = "t";
    public static final String FIELD_I = "i";

    public IONIncTimestamp(int secondsSinceEpoch, int increment) {
        this.mTime = secondsSinceEpoch;
        this.mInc = increment;
    }

    public IONIncTimestamp(IONObject object) {
        this(object.getInt(FIELD_T), object.getInt(FIELD_I));
    }

    public int getTime() {
        return this.mTime;
    }

    public int getIncrement() {
        return this.mInc;
    }

    @Override
    public int compareTo(IONArtifact o) {
        if (o == null) {
            return 1;
        }
        IONIncTimestamp other = (IONIncTimestamp)o;
        int tsCompare = Integer.compare(this.mTime, other.mTime);
        if (tsCompare == 0) {
            return Integer.compare(this.mInc, other.mInc);
        }
        return tsCompare;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IONIncTimestamp)) {
            return false;
        }
        IONIncTimestamp other = (IONIncTimestamp)o;
        return new EqualsBuilder().append(this.mTime, other.mTime).append(this.mInc, other.mInc).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.mTime).append(this.mInc).toHashCode();
    }

    public String toString() {
        try {
            return this.toJSONArtifact().serialize(true);
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    @Override
    public JSONArtifact toJSONArtifact() {
        JSONObject dateObj = new JSONObject();
        JSONObject innerObj = new JSONObject();
        dateObj.put((Object)ION_INC_TS_TYPE, (Object)innerObj);
        innerObj.put((Object)FIELD_T, (Object)this.mTime);
        innerObj.put((Object)FIELD_I, (Object)this.mInc);
        return dateObj;
    }

    @Override
    public IONArtifact duplicate() {
        return new IONIncTimestamp(this.mTime, this.mInc);
    }

    public Date toDate() {
        return new Date(this.mTime * 1000);
    }

    public static IONIncTimestamp fromDate(Date date) {
        return new IONIncTimestamp((int)(date.getTime() / 1000L), 0);
    }
}

