/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.ion;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.OrderedJSONObject;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONArtifact;
import com.ibm.neo.persist.ion.IONBinary;
import com.ibm.neo.persist.ion.IONDate;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONIncTimestamp;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.ion.IONTime;
import com.ibm.neo.persist.ion.IONTimestamp;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class IONObject
extends LinkedHashMap<String, Object>
implements IONArtifact {
    public static final String PRIMARY_ID = "_id";
    private static final long serialVersionUID = 1L;

    public IONObject() {
    }

    public IONObject(Map<String, Object> m) {
        for (Map.Entry<String, Object> e : m.entrySet()) {
            this.put(e.getKey(), IONHelper.toION(e.getValue()));
        }
    }

    @Override
    public JSONArtifact toJSONArtifact() {
        OrderedJSONObject jsonObj = new OrderedJSONObject();
        for (Map.Entry e : this.entrySet()) {
            jsonObj.put(e.getKey(), IONHelper.toJSON(e.getValue()));
        }
        return jsonObj;
    }

    public IONObjectId getPrimaryId() {
        return this.getIONObjectId(PRIMARY_ID);
    }

    public void setPrimaryId(IONObjectId id) {
        this.put(PRIMARY_ID, id);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public String getString(String key, String defaultValue) {
        String s = this.getString(key);
        if (s == null) {
            return defaultValue;
        }
        return s;
    }

    public Number getNumber(String key) {
        return (Number)this.get(key);
    }

    public Number getNumber(String key, Number defaultValue) {
        Number n = this.getNumber(key);
        if (n == null) {
            return defaultValue;
        }
        return n;
    }

    public int getInt(String key) {
        return this.getNumber(key).intValue();
    }

    public int getInt(String key, int defaultValue) {
        Number n = this.getNumber(key);
        if (n == null) {
            return defaultValue;
        }
        return n.intValue();
    }

    public long getLong(String key) {
        return this.getNumber(key).longValue();
    }

    public long getLong(String key, long defaultValue) {
        Number n = this.getNumber(key);
        if (n == null) {
            return defaultValue;
        }
        return n.longValue();
    }

    public float getFloat(String key) {
        return this.getNumber(key).floatValue();
    }

    public float getFloat(String key, float defaultValue) {
        Number n = this.getNumber(key);
        if (n == null) {
            return defaultValue;
        }
        return n.floatValue();
    }

    public double getDouble(String key) {
        return this.getNumber(key).doubleValue();
    }

    public double getDouble(String key, double defaultValue) {
        Number n = this.getNumber(key);
        if (n == null) {
            return defaultValue;
        }
        return n.doubleValue();
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Boolean b = (Boolean)this.get(key);
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    public Date getDate(String key) {
        Object o = this.get(key);
        if (null == o) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof IONDate) {
            return ((IONDate)o).toDate();
        }
        if (o instanceof IONTimestamp) {
            return ((IONTimestamp)o).toDate();
        }
        if (o instanceof IONTime) {
            return ((IONTime)o).toDate();
        }
        throw new ClassCastException();
    }

    public Date getDate(String key, Date defaultValue) {
        Date d = this.getDate(key);
        if (d == null) {
            return defaultValue;
        }
        return d;
    }

    public IONDate getIONDate(String key) {
        Object o = this.get(key);
        if (null == o) {
            return null;
        }
        if (o instanceof IONDate) {
            return (IONDate)o;
        }
        if (o instanceof IONTimestamp) {
            return ((IONTimestamp)o).toIONDate();
        }
        if (o instanceof Date) {
            return new IONDate((Date)o);
        }
        throw new ClassCastException();
    }

    public IONDate getIONDate(String key, IONDate defaultValue) {
        IONDate d = this.getIONDate(key);
        if (d == null) {
            return defaultValue;
        }
        return d;
    }

    public IONTime getIONTime(String key) {
        Object o = this.get(key);
        if (null == o) {
            return null;
        }
        if (o instanceof IONTime) {
            return (IONTime)o;
        }
        if (o instanceof IONTimestamp) {
            return ((IONTimestamp)o).toIONTime();
        }
        if (o instanceof Date) {
            return new IONTime((Date)o);
        }
        throw new ClassCastException();
    }

    public IONTime getIONTime(String key, IONTime defaultValue) {
        IONTime t = this.getIONTime(key);
        if (t == null) {
            return defaultValue;
        }
        return t;
    }

    public IONTimestamp getIONTimestamp(String key) {
        Object o = this.get(key);
        if (null == o) {
            return null;
        }
        if (o instanceof IONTimestamp) {
            return (IONTimestamp)o;
        }
        if (o instanceof Date) {
            return new IONTimestamp((Date)o);
        }
        throw new ClassCastException();
    }

    public IONTimestamp getIONTimestamp(String key, IONTimestamp defaultValue) {
        IONTimestamp ts = this.getIONTimestamp(key);
        if (ts == null) {
            return defaultValue;
        }
        return ts;
    }

    public IONIncTimestamp getIONIncTimestamp(String key) {
        Object o = this.get(key);
        if (null == o) {
            return null;
        }
        if (o instanceof IONIncTimestamp) {
            return (IONIncTimestamp)o;
        }
        throw new ClassCastException();
    }

    public IONIncTimestamp getIONIncTimestamp(String key, IONIncTimestamp defaultValue) {
        IONIncTimestamp ts = this.getIONIncTimestamp(key);
        if (ts == null) {
            return defaultValue;
        }
        return ts;
    }

    public IONObjectId getIONObjectId(String key) {
        return (IONObjectId)this.get(key);
    }

    public IONObject getIONObject(String key) {
        return (IONObject)this.get(key);
    }

    public IONArray getIONArray(String key) {
        return (IONArray)this.get(key);
    }

    public IONBinary getIONBinary(String key) {
        return (IONBinary)this.get(key);
    }

    public <E extends Enum<E>> E getEnum(String key, Class<E> enumType) {
        String stringValue = this.getString(key);
        if (stringValue == null) {
            return null;
        }
        return Enum.valueOf(enumType, stringValue);
    }

    public <E extends Enum<E>> E getEnum(String key, Class<E> enumType, E defaultValue) {
        E e = this.getEnum(key, enumType);
        if (e == null) {
            return defaultValue;
        }
        return e;
    }

    public void setEnum(String key, Enum<?> enumValue) {
        if (null == enumValue) {
            this.put(key, null);
        }
        this.put(key, enumValue.name());
    }

    public boolean putIfNotNull(String key, Object value) {
        if (null == value) {
            return false;
        }
        this.put(key, value);
        return true;
    }

    @Override
    public IONObject duplicate() {
        IONObject copy = new IONObject();
        for (Map.Entry entry : this.entrySet()) {
            copy.put(entry.getKey(), IONHelper.duplicateObject(entry.getValue()));
        }
        return copy;
    }

    @Override
    public String toString() {
        try {
            return this.toJSONArtifact().serialize(true);
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    @Override
    public int compareTo(IONArtifact other) {
        IONObject o = (IONObject)other;
        if (o == null) {
            return 1;
        }
        int mySize = this.size();
        if (mySize != o.size()) {
            return mySize - o.size();
        }
        Iterator myItr = this.entrySet().iterator();
        Iterator oItr = o.entrySet().iterator();
        for (int i = 0; i < mySize; ++i) {
            Map.Entry myEntry = myItr.next();
            Map.Entry otherEntry = oItr.next();
            int keyCompare = ((String)myEntry.getKey()).compareTo((String)otherEntry.getKey());
            if (keyCompare != 0) {
                return keyCompare;
            }
            Object myValue = myEntry.getValue();
            Object otherValue = otherEntry.getValue();
            if (myValue == null) {
                if (otherValue == null) continue;
                return -1;
            }
            if (otherValue == null) {
                return 1;
            }
            int valueCompare = ((Comparable)myValue).compareTo(otherValue);
            if (valueCompare == 0) continue;
            return valueCompare;
        }
        return 0;
    }
}

