/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.ion;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.persist.ion.IONArtifact;
import com.ibm.neo.persist.ion.IONObject;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IONTime
implements IONArtifact {
    public static final String KEY_HOUR_OF_DAY = "hourOfDay";
    public static final String KEY_MINUTE = "minute";
    public static final String KEY_SECOND = "second";
    public static final String KEY_MILLISECOND = "millisecond";
    private final short mHourOfDay;
    private final short mMinute;
    private final short mSecond;
    private final short mMillisecond;

    public IONTime(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        this.mHourOfDay = (short)cal.get(11);
        this.mMinute = (short)cal.get(12);
        this.mSecond = (short)cal.get(13);
        this.mMillisecond = (short)cal.get(14);
    }

    public IONTime(Calendar cal) {
        this.mHourOfDay = (short)cal.get(11);
        this.mMinute = (short)cal.get(12);
        this.mSecond = (short)cal.get(13);
        this.mMillisecond = (short)cal.get(14);
    }

    public IONTime(int hourOfDay, int minute, int second, int millisecond) {
        this.mHourOfDay = (short)hourOfDay;
        this.mMinute = (short)minute;
        this.mSecond = (short)second;
        this.mMillisecond = (short)millisecond;
    }

    public IONTime(IONObject timeObj) {
        this(timeObj.getInt(KEY_HOUR_OF_DAY), timeObj.getInt(KEY_MINUTE), timeObj.getInt(KEY_SECOND), timeObj.getInt(KEY_MILLISECOND));
    }

    @Override
    public IONTime duplicate() {
        return new IONTime(this.mHourOfDay, this.mMinute, this.mSecond, this.mMillisecond);
    }

    public int getHourOfDay() {
        return this.mHourOfDay;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public int getSecond() {
        return this.mSecond;
    }

    public int getMillisecond() {
        return this.mMillisecond;
    }

    public Date toDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        this.toCalendar(cal);
        return cal.getTime();
    }

    public Calendar toCalendar(Calendar cal) {
        if (null == cal) {
            cal = Calendar.getInstance();
            cal.clear();
        }
        cal.set(11, this.mHourOfDay);
        cal.set(12, this.mMinute);
        cal.set(13, this.mSecond);
        cal.set(14, this.mMillisecond);
        return cal;
    }

    @Override
    public JSONArtifact toJSONArtifact() {
        JSONObject timeObj = new JSONObject();
        JSONObject innerObj = new JSONObject();
        timeObj.put((Object)"$ion-time", (Object)innerObj);
        innerObj.put((Object)KEY_HOUR_OF_DAY, (Object)this.mHourOfDay);
        innerObj.put((Object)KEY_MINUTE, (Object)this.mMinute);
        innerObj.put((Object)KEY_SECOND, (Object)this.mSecond);
        innerObj.put((Object)KEY_MILLISECOND, (Object)this.mMillisecond);
        return timeObj;
    }

    @Override
    public int compareTo(IONArtifact other) {
        IONTime o = (IONTime)other;
        if (o == null) {
            return 1;
        }
        if (this.mHourOfDay != o.mHourOfDay) {
            return this.mHourOfDay - o.mHourOfDay;
        }
        if (this.mMinute != o.mMinute) {
            return this.mMinute - o.mMinute;
        }
        if (this.mSecond != o.mSecond) {
            return this.mSecond - o.mSecond;
        }
        return this.mMillisecond - o.mMillisecond;
    }

    public String toString() {
        try {
            return this.toJSONArtifact().serialize(true);
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IONTime)) {
            return false;
        }
        IONTime other = (IONTime)o;
        return new EqualsBuilder().append(this.mHourOfDay, other.mHourOfDay).append(this.mMinute, other.mMinute).append(this.mSecond, other.mSecond).append(this.mMillisecond, other.mMillisecond).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.mHourOfDay).append(this.mMinute).append(this.mSecond).append(this.mMillisecond).toHashCode();
    }
}

