/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.ion;

import com.ibm.json.java.JSONArtifact;
import com.ibm.json.java.JSONObject;
import com.ibm.neo.persist.ion.IONArtifact;
import com.ibm.neo.persist.ion.IONDate;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONTime;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class IONTimestamp
implements IONArtifact {
    public static final String KEY_YEAR = "year";
    public static final String KEY_MONTH = "month";
    public static final String KEY_DAY_OF_MONTH = "dayOfMonth";
    public static final String KEY_HOUR_OF_DAY = "hourOfDay";
    public static final String KEY_MINUTE = "minute";
    public static final String KEY_SECOND = "second";
    public static final String KEY_MILLISECOND = "millisecond";
    private final short mYear;
    private final short mMonth;
    private final short mDayOfMonth;
    private final short mHourOfDay;
    private final short mMinute;
    private final short mSecond;
    private final short mMillisecond;

    public IONTimestamp(Date dt) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(dt);
        this.mYear = (short)cal.get(1);
        this.mMonth = (short)cal.get(2);
        this.mDayOfMonth = (short)cal.get(5);
        this.mHourOfDay = (short)cal.get(11);
        this.mMinute = (short)cal.get(12);
        this.mSecond = (short)cal.get(13);
        this.mMillisecond = (short)cal.get(14);
    }

    public IONTimestamp(Calendar cal) {
        this.mYear = (short)cal.get(1);
        this.mMonth = (short)cal.get(2);
        this.mDayOfMonth = (short)cal.get(5);
        this.mHourOfDay = (short)cal.get(11);
        this.mMinute = (short)cal.get(12);
        this.mSecond = (short)cal.get(13);
        this.mMillisecond = (short)cal.get(14);
    }

    public IONTimestamp(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second, int millisecond) {
        this.mYear = (short)year;
        this.mMonth = (short)month;
        this.mDayOfMonth = (short)dayOfMonth;
        this.mHourOfDay = (short)hourOfDay;
        this.mMinute = (short)minute;
        this.mSecond = (short)second;
        this.mMillisecond = (short)millisecond;
    }

    public IONTimestamp(IONObject tsObj) {
        this(tsObj.getInt(KEY_YEAR), tsObj.getInt(KEY_MONTH), tsObj.getInt(KEY_DAY_OF_MONTH), tsObj.getInt(KEY_HOUR_OF_DAY), tsObj.getInt(KEY_MINUTE), tsObj.getInt(KEY_SECOND), tsObj.getInt(KEY_MILLISECOND));
    }

    @Override
    public IONTimestamp duplicate() {
        return new IONTimestamp(this.mYear, this.mMonth, this.mDayOfMonth, this.mHourOfDay, this.mMinute, this.mSecond, this.mMillisecond);
    }

    public int getYear() {
        return this.mYear;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getDayOfMonth() {
        return this.mDayOfMonth;
    }

    public int getHourOfDay() {
        return this.mHourOfDay;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public int getSecond() {
        return this.mSecond;
    }

    public int getMillisecond() {
        return this.mMillisecond;
    }

    public IONDate toIONDate() {
        return new IONDate(this.getYear(), this.getMonth(), this.getDayOfMonth());
    }

    public IONTime toIONTime() {
        return new IONTime(this.getHourOfDay(), this.getMinute(), this.getSecond(), this.getMillisecond());
    }

    public Date toDate() {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        this.toCalendar(cal);
        return cal.getTime();
    }

    public Calendar toCalendar(Calendar cal) {
        if (null == cal) {
            cal = Calendar.getInstance();
            cal.clear();
        }
        cal.set(1, this.mYear);
        cal.set(2, this.mMonth);
        cal.set(5, this.mDayOfMonth);
        cal.set(11, this.mHourOfDay);
        cal.set(12, this.mMinute);
        cal.set(13, this.mSecond);
        cal.set(14, this.mMillisecond);
        return cal;
    }

    @Override
    public JSONArtifact toJSONArtifact() {
        JSONObject tsObj = new JSONObject();
        JSONObject innerObj = new JSONObject();
        tsObj.put((Object)"$ion-timestamp", (Object)innerObj);
        innerObj.put((Object)KEY_YEAR, (Object)this.mYear);
        innerObj.put((Object)KEY_MONTH, (Object)this.mMonth);
        innerObj.put((Object)KEY_DAY_OF_MONTH, (Object)this.mDayOfMonth);
        innerObj.put((Object)KEY_HOUR_OF_DAY, (Object)this.mHourOfDay);
        innerObj.put((Object)KEY_MINUTE, (Object)this.mMinute);
        innerObj.put((Object)KEY_SECOND, (Object)this.mSecond);
        innerObj.put((Object)KEY_MILLISECOND, (Object)this.mMillisecond);
        return tsObj;
    }

    @Override
    public int compareTo(IONArtifact other) {
        IONTimestamp o = (IONTimestamp)other;
        if (o == null) {
            return 1;
        }
        if (this.mYear != o.mYear) {
            return this.mYear - o.mYear;
        }
        if (this.mMonth != o.mMonth) {
            return this.mMonth - o.mMonth;
        }
        if (this.mDayOfMonth != o.mDayOfMonth) {
            return this.mDayOfMonth - o.mDayOfMonth;
        }
        if (this.mHourOfDay != o.mHourOfDay) {
            return this.mHourOfDay - o.mHourOfDay;
        }
        if (this.mMinute != o.mMinute) {
            return this.mMinute - o.mMinute;
        }
        if (this.mSecond != o.mSecond) {
            return this.mSecond - o.mSecond;
        }
        return this.mMillisecond - o.mMillisecond;
    }

    public String toString() {
        try {
            return this.toJSONArtifact().serialize(true);
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IONTimestamp)) {
            return false;
        }
        IONTimestamp other = (IONTimestamp)o;
        return new EqualsBuilder().append(this.mYear, other.mYear).append(this.mMonth, other.mMonth).append(this.mDayOfMonth, other.mDayOfMonth).append(this.mHourOfDay, other.mHourOfDay).append(this.mMinute, other.mMinute).append(this.mSecond, other.mSecond).append(this.mMillisecond, other.mMillisecond).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.mYear).append(this.mMonth).append(this.mDayOfMonth).append(this.mHourOfDay).append(this.mMinute).append(this.mSecond).append(this.mMillisecond).toHashCode();
    }
}

