/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.nobject;

import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.EWriteConcern;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ion.IONCodingService;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCursor;
import java.util.ArrayList;
import java.util.List;

public class NobjectCollection<N extends Nobject> {
    public static final String SET_FIELD_OPERATOR = "$set";
    private final IDocumentCollection mDocumentCollection;
    private final Class<N> mNobjectType;

    public NobjectCollection(IDocumentCollection collection, Class<N> nobjectType) {
        this.mDocumentCollection = collection;
        this.mNobjectType = nobjectType;
    }

    public IDocumentDatabase getDatabase() {
        return this.mDocumentCollection.getDatabase();
    }

    public String getName() {
        return this.mDocumentCollection.getName();
    }

    public String getFullName() {
        return this.mDocumentCollection.getFullName();
    }

    public Class<N> getNobjectType() {
        return this.mNobjectType;
    }

    public IDocumentCollection getDocumentCollection() {
        return this.mDocumentCollection;
    }

    public N get(IONObjectId id) throws PersistenceException {
        return this.get(id, (EReadPreference)null);
    }

    public N get(IONObjectId id, EReadPreference readPref) throws PersistenceException {
        Nobject nobj = (Nobject)IONHelper.toPOJO(this.mDocumentCollection.get(id, readPref), this.mNobjectType);
        if (null == nobj) {
            return null;
        }
        nobj.setDBName(this.mDocumentCollection.getDatabase().getName());
        nobj.setCollectionName(this.mDocumentCollection.getName());
        return (N)nobj;
    }

    public N get(IONObjectId id, IONObject projection) throws PersistenceException {
        return this.get(id, projection, null);
    }

    public N get(IONObjectId id, IONObject projection, EReadPreference readPref) throws PersistenceException {
        this.updateProjection(projection);
        Nobject nobj = (Nobject)IONHelper.toPOJO(this.mDocumentCollection.get(id, projection, readPref), this.mNobjectType);
        if (null == nobj) {
            return null;
        }
        nobj.setDBName(this.mDocumentCollection.getDatabase().getName());
        nobj.setCollectionName(this.mDocumentCollection.getName());
        return (N)nobj;
    }

    public long count() throws PersistenceException {
        return this.count((EReadPreference)null);
    }

    public long count(EReadPreference readPref) throws PersistenceException {
        return this.mDocumentCollection.count(readPref);
    }

    public long count(IONObject query) throws PersistenceException {
        return this.count(query, null);
    }

    public long count(IONObject query, EReadPreference readPref) throws PersistenceException {
        return this.mDocumentCollection.count(query, readPref);
    }

    public N findOne(IONObject query) throws PersistenceException {
        return this.findOne(query, (EReadPreference)null);
    }

    public N findOne(IONObject query, EReadPreference readPref) throws PersistenceException {
        Nobject nobj = (Nobject)IONHelper.toPOJO(this.mDocumentCollection.findOne(query, readPref), this.mNobjectType);
        if (null == nobj) {
            return null;
        }
        nobj.setDBName(this.mDocumentCollection.getDatabase().getName());
        nobj.setCollectionName(this.mDocumentCollection.getName());
        return (N)nobj;
    }

    public N findOne(IONObject query, IONObject projection) throws PersistenceException {
        return this.findOne(query, projection, null);
    }

    public N findOne(IONObject query, IONObject projection, EReadPreference readPref) throws PersistenceException {
        this.updateProjection(projection);
        Nobject nobj = (Nobject)IONHelper.toPOJO(this.mDocumentCollection.findOne(query, projection, readPref), this.mNobjectType);
        if (null == nobj) {
            return null;
        }
        nobj.setDBName(this.mDocumentCollection.getDatabase().getName());
        nobj.setCollectionName(this.mDocumentCollection.getName());
        return (N)nobj;
    }

    public ICursor<N> find(IONObject query) throws PersistenceException {
        return new NobjectCursor<N>(this.mDocumentCollection, this.mDocumentCollection.find(query), this.mNobjectType);
    }

    public ICursor<N> find(IONObject query, IONObject projection) throws PersistenceException {
        this.updateProjection(projection);
        return new NobjectCursor<N>(this.mDocumentCollection, this.mDocumentCollection.find(query, projection), this.mNobjectType);
    }

    public ICursor<N> findAll() throws PersistenceException {
        return new NobjectCursor<N>(this.mDocumentCollection, this.mDocumentCollection.findAll(), this.mNobjectType);
    }

    public ICursor<N> findAll(IONObject projection) throws PersistenceException {
        this.updateProjection(projection);
        return new NobjectCursor<N>(this.mDocumentCollection, this.mDocumentCollection.findAll(projection), this.mNobjectType);
    }

    public boolean remove(IONObjectId id) throws PersistenceException {
        return this.remove(id, (EWriteConcern)null);
    }

    public boolean remove(IONObjectId id, EWriteConcern writeConcern) throws PersistenceException {
        return this.mDocumentCollection.remove(id, writeConcern);
    }

    public int remove(IONObject query) throws PersistenceException {
        return this.remove(query, (EWriteConcern)null);
    }

    public int remove(IONObject query, EWriteConcern writeConcern) throws PersistenceException {
        return this.mDocumentCollection.remove(query, writeConcern);
    }

    public void save(N nobj) throws PersistenceException {
        this.save(nobj, null);
    }

    public void save(N nobj, EWriteConcern writeConcern) throws PersistenceException {
        IONObject ionObj = IONCodingService.encode(nobj);
        this.preSave(ionObj);
        this.mDocumentCollection.save(ionObj, writeConcern);
        if (null == ((Nobject)nobj).getId()) {
            ((Nobject)nobj).setId(ionObj.getPrimaryId());
        }
        ((Nobject)nobj).setDBName(this.mDocumentCollection.getDatabase().getName());
        ((Nobject)nobj).setCollectionName(this.mDocumentCollection.getName());
    }

    @Deprecated
    public void insert(N ... nobjs) throws PersistenceException {
        int i;
        ArrayList<IONObject> ionObjs = new ArrayList<IONObject>(nobjs.length);
        for (i = 0; i < nobjs.length; ++i) {
            IONObject ionObj = IONCodingService.encode(nobjs[i]);
            this.preSave(ionObj);
            ionObjs.add(ionObj);
        }
        this.mDocumentCollection.insert(ionObjs);
        for (i = 0; i < nobjs.length; ++i) {
            ((Nobject)nobjs[i]).setId(((IONObject)ionObjs.get(i)).getPrimaryId());
            ((Nobject)nobjs[i]).setDBName(this.mDocumentCollection.getDatabase().getName());
            ((Nobject)nobjs[i]).setCollectionName(this.mDocumentCollection.getName());
        }
    }

    public void insert(List<N> nobjs) throws PersistenceException {
        this.insert((N)nobjs, (EWriteConcern)null);
    }

    public void insert(List<N> nobjs, EWriteConcern writeConcern) throws PersistenceException {
        int i;
        ArrayList<IONObject> ionObjs = new ArrayList<IONObject>(nobjs.size());
        for (i = 0; i < nobjs.size(); ++i) {
            IONObject ionObj = IONCodingService.encode(nobjs.get(i));
            this.preSave(ionObj);
            ionObjs.add(ionObj);
        }
        this.mDocumentCollection.insert(ionObjs, writeConcern);
        for (i = 0; i < nobjs.size(); ++i) {
            Nobject nobj = (Nobject)nobjs.get(i);
            nobj.setId(((IONObject)ionObjs.get(i)).getPrimaryId());
            nobj.setDBName(this.mDocumentCollection.getDatabase().getName());
            nobj.setCollectionName(this.mDocumentCollection.getName());
        }
    }

    public void insert(N nobj) throws PersistenceException {
        this.insert(nobj, (EWriteConcern)null);
    }

    public void insert(N nobj, EWriteConcern writeConcern) throws PersistenceException {
        IONObject ionObj = IONCodingService.encode(nobj);
        this.preSave(ionObj);
        this.mDocumentCollection.insert(ionObj, writeConcern);
        if (null == ((Nobject)nobj).getId()) {
            ((Nobject)nobj).setId(ionObj.getPrimaryId());
        }
        ((Nobject)nobj).setDBName(this.mDocumentCollection.getDatabase().getName());
        ((Nobject)nobj).setCollectionName(this.mDocumentCollection.getName());
    }

    public int update(N nobj) throws PersistenceException {
        return this.update(nobj, null);
    }

    public int update(N nobj, EWriteConcern writeConcern) throws PersistenceException {
        IONObject update = IONCodingService.encode(nobj);
        IONObject query = new IONObject();
        query.put("_id", update.getPrimaryId());
        update.remove("_id");
        update.remove("__type");
        IONObject updateSetFields = new IONObject();
        updateSetFields.put(SET_FIELD_OPERATOR, update);
        int updated = this.mDocumentCollection.update(query, updateSetFields, false, false, writeConcern);
        ((Nobject)nobj).setDBName(this.mDocumentCollection.getDatabase().getName());
        ((Nobject)nobj).setCollectionName(this.mDocumentCollection.getName());
        return updated;
    }

    public void drop() throws PersistenceException {
        this.mDocumentCollection.drop();
    }

    public String toString() {
        return this.getFullName();
    }

    protected void updateProjection(IONObject projection) throws PersistenceException {
        projection.put("__type", 1);
    }

    protected void preSave(IONObject obj) throws PersistenceException {
    }
}

