/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.nobject;

import com.ibm.neo.persist.ECursorOption;
import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.cursor.FieldProjectingCursor;
import com.ibm.neo.persist.ion.IONHelper;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.nobject.Nobject;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class NobjectCursor<N extends Nobject>
implements ICursor<N> {
    private final IDocumentCollection mDocumentCollection;
    private final ICursor<IONObject> mDocumentCursor;
    private final Class<N> mNobjectType;

    public NobjectCursor(IDocumentCollection documentCollection, ICursor<IONObject> documentCursor, Class<N> nobjectType) {
        this.mDocumentCollection = documentCollection;
        this.mDocumentCursor = documentCursor;
        this.mNobjectType = nobjectType;
    }

    @Override
    public boolean supportsOption(ECursorOption option) throws PersistenceException {
        return this.mDocumentCursor.supportsOption(option);
    }

    @Override
    public EnumSet<ECursorOption> getOptions() throws PersistenceException {
        return this.mDocumentCursor.getOptions();
    }

    @Override
    public ICursor<N> setOptions(EnumSet<ECursorOption> options) throws PersistenceException {
        this.mDocumentCursor.setOptions(options);
        return this;
    }

    @Override
    public boolean supportsMaxTime() throws PersistenceException {
        return this.mDocumentCursor.supportsMaxTime();
    }

    @Override
    public ICursor<N> maxTime(long maxTime, TimeUnit timeUnit) throws PersistenceException {
        this.mDocumentCursor.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public ICursor<N> setReadPreference(EReadPreference readPref) throws PersistenceException {
        this.mDocumentCursor.setReadPreference(readPref);
        return this;
    }

    @Override
    public void close() throws PersistenceException {
        this.mDocumentCursor.close();
    }

    @Override
    public int count() throws PersistenceException {
        return this.mDocumentCursor.count();
    }

    @Override
    public N current() throws PersistenceException {
        Nobject nobj = (Nobject)IONHelper.toPOJO(this.mDocumentCursor.current(), this.mNobjectType);
        if (null == nobj) {
            return null;
        }
        nobj.setDBName(this.mDocumentCollection.getDatabase().getName());
        nobj.setCollectionName(this.mDocumentCollection.getName());
        return (N)nobj;
    }

    @Override
    public boolean hasNext() throws PersistenceException {
        return this.mDocumentCursor.hasNext();
    }

    @Override
    public N next() throws PersistenceException {
        Nobject nobj = (Nobject)IONHelper.toPOJO(this.mDocumentCursor.next(), this.mNobjectType);
        if (null == nobj) {
            return null;
        }
        nobj.setDBName(this.mDocumentCollection.getDatabase().getName());
        nobj.setCollectionName(this.mDocumentCollection.getName());
        return (N)nobj;
    }

    @Override
    public NobjectCursor<N> sort(IONObject orderBy) throws PersistenceException {
        this.mDocumentCursor.sort(orderBy);
        return this;
    }

    @Override
    public ICursor<N> sortNatural(ESortOrder order) throws PersistenceException {
        this.mDocumentCursor.sortNatural(order);
        return this;
    }

    @Override
    public NobjectCursor<N> limit(int limit) throws PersistenceException {
        this.mDocumentCursor.limit(limit);
        return this;
    }

    @Override
    public List<N> toListAndClose() throws PersistenceException {
        ArrayList<Object> list = new ArrayList<Object>();
        while (this.hasNext()) {
            list.add(this.next());
        }
        this.close();
        return list;
    }

    @Override
    public <U> ICursor<U> project(String fieldName, Class<U> fieldType) throws PersistenceException {
        return new FieldProjectingCursor<U>(this.mDocumentCursor, fieldName, fieldType);
    }
}

