/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.query;

import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.cursor.IteratorBackedCursor;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.AggregationOperator;
import com.ibm.neo.persist.query.AggregationParser;
import java.util.Collection;
import java.util.List;

public class AggregationEvaluator {
    private List<AggregationOperator> mOperatorPipeline;

    public AggregationEvaluator(List<IONObject> aggregationPipeline) {
        this.mOperatorPipeline = AggregationParser.parse(aggregationPipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IONArray aggregate(ICursor<IONObject> input) throws PersistenceException {
        List<IONObject> resultList = null;
        for (AggregationOperator operator : this.mOperatorPipeline) {
            if (resultList == null) {
                resultList = operator.aggregate(input);
                continue;
            }
            try (IteratorBackedCursor itr = new IteratorBackedCursor(resultList.iterator());){
                resultList = operator.aggregate(itr);
            }
        }
        if (resultList == null) {
            return new IONArray();
        }
        return new IONArray((Collection<?>)resultList);
    }
}

