/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.query;

import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.AggregationOperator;
import com.ibm.neo.persist.query.GroupOperator;
import com.ibm.neo.persist.query.InvalidAggregationException;
import com.ibm.neo.persist.query.MatchOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AggregationParser {
    public static List<AggregationOperator> parse(List<IONObject> aggregationPipeline) throws InvalidAggregationException {
        ArrayList<AggregationOperator> operators = new ArrayList<AggregationOperator>();
        for (IONObject pipelineEntry : aggregationPipeline) {
            try {
                if (pipelineEntry.containsKey(Op.$match.name())) {
                    operators.add(AggregationParser.parseMatchOperator(pipelineEntry.getIONObject(Op.$match.name())));
                    continue;
                }
                if (pipelineEntry.containsKey(Op.$group.name())) {
                    operators.add(AggregationParser.parseGroupOperator(pipelineEntry.getIONObject(Op.$group.name())));
                    continue;
                }
                throw new InvalidAggregationException.UnsupportedAggregationOperator(pipelineEntry.toString());
            }
            catch (ClassCastException e) {
                throw new InvalidAggregationException.InvalidAggregationPipelineEntry(e);
            }
        }
        return operators;
    }

    static GroupOperator parseGroupOperator(IONObject entry) throws InvalidAggregationException {
        String groupField = null;
        if (entry == null) {
            throw new InvalidAggregationException.InvalidAggregationPipelineEntry((Object)"$group field cannot be null.");
        }
        if (entry.containsKey("_id")) {
            try {
                groupField = entry.getString("_id");
            }
            catch (ClassCastException e) {
                throw new InvalidAggregationException("$group operation is currently limited to a field name.");
            }
        } else {
            throw new InvalidAggregationException("$group operator requires an _id field.");
        }
        ArrayList<GroupOperator.Operation> operations = new ArrayList<GroupOperator.Operation>();
        for (Map.Entry keyVal : entry.entrySet()) {
            String resultField = (String)keyVal.getKey();
            if (resultField.equals("_id")) continue;
            try {
                IONObject ionValue = (IONObject)keyVal.getValue();
                if (ionValue.containsKey(GroupOp.$sum.name())) {
                    Object sumVal = ionValue.get(GroupOp.$sum.name());
                    if (sumVal instanceof Number) {
                        operations.add(new GroupOperator.SumIncrement(resultField, ((Number)sumVal).doubleValue()));
                        continue;
                    }
                    if (sumVal instanceof String) {
                        String sumField = (String)sumVal;
                        if (!sumField.startsWith("$")) {
                            throw new InvalidAggregationException("A $sum operator that refers to a field must start with with '$'.");
                        }
                        operations.add(new GroupOperator.SumField(resultField, sumField.substring(1)));
                        continue;
                    }
                    throw new InvalidAggregationException("$sum operator for field " + resultField + "is expected to be a number or a string starting with '$'.");
                }
                throw new InvalidAggregationException.UnsupportedAggregationOperator(ionValue.toString());
            }
            catch (ClassCastException e) {
                throw new InvalidAggregationException("Value for " + resultField + "is expected to be an IONObject.");
            }
        }
        return new GroupOperator(groupField, operations);
    }

    static MatchOperator parseMatchOperator(IONObject entry) throws InvalidAggregationException {
        if (entry == null) {
            throw new InvalidAggregationException.InvalidAggregationPipelineEntry((Object)"$match field cannot be null.");
        }
        return new MatchOperator(entry);
    }

    static enum GroupOp {
        $sum;

    }

    static enum Op {
        $match,
        $group;

    }
}

