/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.query;

import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.ComparableRegex;
import com.ibm.neo.persist.query.ConditionalOperator;
import com.ibm.neo.persist.query.QueryParser;

public class ComparisonOperator
extends ConditionalOperator {
    private final QueryParser.Operator mOp;
    private final Comparable<?> mValue;

    ComparisonOperator(QueryParser.Operator op, String field, Comparable<?> value) {
        super(field);
        this.mOp = op;
        this.mValue = this.prepareValue(value);
    }

    @Override
    boolean matches(IONObject object) {
        if (object == null) {
            return false;
        }
        Object fieldValue = this.getSelector().getFieldValue(object);
        if (fieldValue == null) {
            return this.mValue == null;
        }
        if (this.mValue == null) {
            return false;
        }
        Comparable<?> value = this.prepareValue(fieldValue);
        try {
            switch (this.mOp) {
                case EQ: {
                    return value.equals(this.mValue);
                }
                case $ne: {
                    return !value.equals(this.mValue);
                }
                case $gt: {
                    return value.compareTo(this.mValue) > 0;
                }
                case $gte: {
                    return value.compareTo(this.mValue) >= 0;
                }
                case $lt: {
                    return value.compareTo(this.mValue) < 0;
                }
                case $lte: {
                    return value.compareTo(this.mValue) <= 0;
                }
                case $regex: {
                    return ((ComparableRegex)this.mValue).compareTo((String)((Object)value)) == 0;
                }
            }
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }
}

