/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.query;

import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONArtifact;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.InvalidQueryException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class FieldSelector {
    private final String[] mFieldCrumbs;
    private final Integer[] mArrayIndexes;

    public FieldSelector(String selection) throws InvalidQueryException.InvalidFieldSelector {
        if (selection == null || selection.isEmpty()) {
            throw new InvalidQueryException.InvalidFieldSelector(selection);
        }
        if (selection.length() >= 2) {
            this.mFieldCrumbs = selection.split("\\.");
            if (this.mFieldCrumbs.length == 0) {
                throw new InvalidQueryException.InvalidFieldSelector(selection);
            }
            for (String crumb : this.mFieldCrumbs) {
                if (!crumb.isEmpty()) continue;
                throw new InvalidQueryException.InvalidFieldSelector(selection);
            }
            this.mArrayIndexes = new Integer[this.mFieldCrumbs.length];
            for (int i = 0; i < this.mArrayIndexes.length; ++i) {
                try {
                    this.mArrayIndexes[i] = Integer.parseInt(this.mFieldCrumbs[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        } else {
            this.mFieldCrumbs = new String[1];
            this.mFieldCrumbs[0] = selection;
            this.mArrayIndexes = new Integer[1];
        }
    }

    public IONArtifact getFieldContainer(IONObject object) {
        return this.getFieldContainer(object, false);
    }

    public IONArtifact getFieldContainer(IONObject object, boolean createIfMissing) {
        IONObject value = object;
        for (int i = 0; i < this.mFieldCrumbs.length - 1; ++i) {
            String field = this.mFieldCrumbs[i];
            if (value instanceof IONObject) {
                IONObject ionValue = value;
                if (ionValue.containsKey(field)) {
                    value = ionValue.get(field);
                    continue;
                }
                if (createIfMissing) {
                    IONObject newNestedValue = new IONObject();
                    ionValue.put(field, newNestedValue);
                    value = newNestedValue;
                    continue;
                }
            }
            if (this.mArrayIndexes[i] != null && value instanceof IONArray) {
                try {
                    value = ((IONArray)((Object)value)).get(this.mArrayIndexes[i]);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
            }
            return null;
        }
        if (!(value instanceof IONObject) && !(value instanceof IONArray)) {
            return null;
        }
        return value;
    }

    public Object getFieldValue(IONObject object) {
        IONObject ionParent;
        IONArtifact parent = this.getFieldContainer(object);
        if (parent == null) {
            return null;
        }
        int lastCrumbInx = this.mFieldCrumbs.length - 1;
        String field = this.mFieldCrumbs[lastCrumbInx];
        if (parent instanceof IONObject && (ionParent = (IONObject)parent).containsKey(field)) {
            return ionParent.get(field);
        }
        if (this.mArrayIndexes[lastCrumbInx] != null && parent instanceof IONArray) {
            try {
                return ((IONArray)parent).get(this.mArrayIndexes[lastCrumbInx]);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        return null;
    }

    public boolean fieldExists(IONObject object) {
        IONArtifact parent = this.getFieldContainer(object);
        if (!(parent instanceof IONObject)) {
            return false;
        }
        IONObject ionParent = (IONObject)parent;
        return ionParent.containsKey(this.mFieldCrumbs[this.mFieldCrumbs.length - 1]);
    }

    public String getTailingCrumb() {
        return this.mFieldCrumbs[this.mFieldCrumbs.length - 1];
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof FieldSelector)) {
            return false;
        }
        FieldSelector o = (FieldSelector)other;
        return new EqualsBuilder().append((Object[])this.mArrayIndexes, (Object[])o.mArrayIndexes).append((Object[])this.mFieldCrumbs, (Object[])o.mFieldCrumbs).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object[])this.mArrayIndexes).append((Object[])this.mFieldCrumbs).toHashCode();
    }
}

