/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.query;

import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectBuilder;
import com.ibm.neo.persist.query.AggregationOperator;
import com.ibm.neo.persist.query.FieldSelector;
import com.ibm.neo.persist.query.InvalidAggregationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.mutable.MutableDouble;

public class GroupOperator
extends AggregationOperator {
    private static final String NULL_GROUP_KEY = "__null_key__";
    private final String groupField;
    private FieldSelector groupValueSelector = null;
    private final List<Operation> operations;

    public GroupOperator(String groupField, List<Operation> operations) {
        String string = this.groupField = groupField == null ? NULL_GROUP_KEY : groupField;
        if (this.groupField.startsWith("$")) {
            if (groupField.length() == 1) {
                throw new InvalidAggregationException("Illegal group field '$'.");
            }
            this.groupValueSelector = new FieldSelector(groupField.substring(1));
        }
        this.operations = operations;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof GroupOperator)) {
            return false;
        }
        GroupOperator o = (GroupOperator)other;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.groupField, (Object)o.groupField).append((Object)this.groupValueSelector, (Object)o.groupValueSelector).append(this.operations, o.operations).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.groupField).append((Object)this.groupValueSelector).append(this.operations).toHashCode();
    }

    @Override
    List<IONObject> aggregate(ICursor<IONObject> input) throws PersistenceException {
        HashMap<Object, IONObject> resultMap = new HashMap<Object, IONObject>();
        while (input.hasNext()) {
            this.processDocument(resultMap, input.next());
        }
        ArrayList<IONObject> result = new ArrayList<IONObject>(resultMap.values());
        return this.convertResultFieldsToDoubles(result);
    }

    private Object getGroupKey(IONObject document) {
        if (this.groupValueSelector == null) {
            return this.groupField;
        }
        Object value = this.groupValueSelector.getFieldValue(document);
        if (value == null) {
            return this.groupField;
        }
        return value;
    }

    private void processDocument(Map<Object, IONObject> resultMap, IONObject document) {
        Object groupKey = this.getGroupKey(document);
        IONObject groupValue = null;
        if (resultMap.containsKey(groupKey)) {
            groupValue = resultMap.get(groupKey);
        } else {
            Object idValue = groupKey.equals(NULL_GROUP_KEY) ? null : groupKey;
            groupValue = new IONObjectBuilder().put("_id", idValue).toDocument();
            resultMap.put(groupKey, groupValue);
        }
        for (Operation op : this.operations) {
            op.evaluate(groupValue, document);
        }
    }

    private List<IONObject> convertResultFieldsToDoubles(List<IONObject> list) {
        HashSet<String> resultFields = new HashSet<String>();
        for (Operation op : this.operations) {
            resultFields.add(op.resultField);
        }
        for (IONObject obj : list) {
            for (String field : resultFields) {
                obj.put(field, obj.getDouble(field));
            }
        }
        return list;
    }

    static class SumField
    extends Operation {
        private String inputField;

        SumField(String resultField, String inputField) {
            super(resultField);
            this.inputField = inputField;
        }

        @Override
        protected void evaluate(IONObject result, IONObject document) {
            double value;
            try {
                value = document.getDouble(this.inputField, 0.0);
            }
            catch (ClassCastException e) {
                throw new InvalidAggregationException.IllegalFieldValueType(document, this.inputField, Number.class);
            }
            if (!result.containsKey(this.resultField)) {
                result.put(this.resultField, new MutableDouble(value));
            } else if (value != 0.0) {
                MutableDouble d = (MutableDouble)result.get(this.resultField);
                d.add(value);
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof SumField)) {
                return false;
            }
            SumField o = (SumField)other;
            return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.inputField, (Object)o.inputField).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.inputField).toHashCode();
        }
    }

    static class SumIncrement
    extends Operation {
        private double increment;

        SumIncrement(String resultField, double increment) {
            super(resultField);
            this.increment = increment;
        }

        @Override
        protected void evaluate(IONObject result, IONObject document) {
            if (!result.containsKey(this.resultField)) {
                result.put(this.resultField, new MutableDouble(this.increment));
            } else {
                MutableDouble d = (MutableDouble)result.get(this.resultField);
                d.add(this.increment);
            }
        }

        @Override
        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof SumIncrement)) {
                return false;
            }
            SumIncrement o = (SumIncrement)other;
            return new EqualsBuilder().appendSuper(super.equals(other)).append(this.increment, o.increment).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.increment).toHashCode();
        }
    }

    static abstract class Operation {
        protected String resultField;

        Operation(String resultField) {
            if (resultField == null) {
                throw new InvalidAggregationException("The accumumator field name for a group operator cannot be null.");
            }
            this.resultField = resultField;
        }

        protected abstract void evaluate(IONObject var1, IONObject var2);

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof Operation)) {
                return false;
            }
            Operation o = (Operation)other;
            return new EqualsBuilder().append((Object)this.resultField, (Object)o.resultField).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.resultField).toHashCode();
        }
    }
}

