/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.query;

import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.QueryParser;

public class InvalidQueryException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public InvalidQueryException() {
    }

    public InvalidQueryException(String message) {
        super(message);
    }

    private static String safeIONObjectToString(IONObject ion) {
        try {
            return ion.toString();
        }
        catch (Exception e) {
            return "<unprintable IONObject>";
        }
    }

    public static class InvalidProjectionClause
    extends InvalidQueryException {
        private static final long serialVersionUID = 1L;

        public InvalidProjectionClause(IONObject projection, String reason) {
            super("The projection clause " + InvalidQueryException.safeIONObjectToString(projection) + " is not valid: " + reason);
        }

        public InvalidProjectionClause(String reason) {
            super(reason);
        }
    }

    public static class UnsupportedQueryClause
    extends InvalidQueryException {
        private static final long serialVersionUID = 1L;

        public UnsupportedQueryClause(QueryParser.Operator op) {
            super("The query operator " + (Object)((Object)op) + " is not currently supported.");
        }
    }

    public static class InvalidQueryClause
    extends InvalidQueryException {
        private static final long serialVersionUID = 1L;

        public InvalidQueryClause(IONObject query, String reason) {
            super("The query clause " + InvalidQueryException.safeIONObjectToString(query) + " is not valid: " + reason);
        }

        public InvalidQueryClause(String reason) {
            super(reason);
        }
    }

    public static class InvalidSortClause
    extends InvalidQueryException {
        private static final long serialVersionUID = 1L;

        public InvalidSortClause(IONObject sort, String reason) {
            super("The sort clause " + InvalidQueryException.safeIONObjectToString(sort) + " is not valid: " + reason);
        }
    }

    public static class InvalidFieldSelector
    extends InvalidQueryException {
        private static final long serialVersionUID = 1L;

        public InvalidFieldSelector(String fieldSelector) {
            super("The string '" + fieldSelector + "' is not a valid field selector.");
        }
    }
}

