/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.query;

import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.AggregationOperator;
import com.ibm.neo.persist.query.InvalidAggregationException;
import com.ibm.neo.persist.query.QueryEvaluator;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class MatchOperator
extends AggregationOperator {
    private final IONObject query;
    private final QueryEvaluator queryEvaluator;

    public MatchOperator(IONObject query) {
        try {
            this.query = query;
            this.queryEvaluator = new QueryEvaluator(query);
        }
        catch (Exception e) {
            throw new InvalidAggregationException.InvalidAggregationPipelineEntry(e);
        }
    }

    @Override
    List<IONObject> aggregate(ICursor<IONObject> input) throws PersistenceException {
        ArrayList<IONObject> result = new ArrayList<IONObject>();
        while (input.hasNext()) {
            if (!this.queryEvaluator.matches(input.next())) continue;
            result.add(input.current());
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof MatchOperator)) {
            return false;
        }
        MatchOperator o = (MatchOperator)other;
        return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.query, (Object)o.query).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.query).toHashCode();
    }
}

