/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.query;

import com.ibm.neo.persist.ion.IONArtifact;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.query.FieldSelector;
import com.ibm.neo.persist.query.InvalidQueryException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ProjectionEvaluator {
    private static String ID_KEY = "_id";
    private final boolean mIncludeId;
    private final boolean mRetainFields;
    private final Set<String> mFields;
    private static final EnumSet<UnsupportedProjectionOperators> sUnsupportedOperators = EnumSet.allOf(UnsupportedProjectionOperators.class);

    public ProjectionEvaluator(IONObject projection) {
        if (projection == null) {
            projection = new IONObject();
        }
        this.mIncludeId = !projection.containsKey(ID_KEY) || projection.getInt(ID_KEY) != 0;
        Boolean keepMode = null;
        for (Map.Entry entry : projection.entrySet()) {
            if (((String)entry.getKey()).equals(ID_KEY)) continue;
            try {
                if (sUnsupportedOperators.contains((Object)UnsupportedProjectionOperators.valueOf((String)entry.getKey()))) {
                    throw new InvalidQueryException.InvalidProjectionClause(projection, "The operator " + (String)entry.getKey() + " is not supported.");
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            Number projValue = projection.getNumber((String)entry.getKey());
            if (projValue == null) {
                throw new InvalidQueryException.InvalidProjectionClause(projection, "At least one value is not a number.");
            }
            if (projValue.equals(0)) {
                if (Boolean.TRUE.equals(keepMode)) {
                    throw new InvalidQueryException.InvalidProjectionClause(projection, "Inclusion and exclusion semantics may not be combined in one projection clause.");
                }
                keepMode = false;
                continue;
            }
            if (Boolean.FALSE.equals(keepMode)) {
                throw new InvalidQueryException.InvalidProjectionClause(projection, "Inclusion and exclusion semantics may not be combined in one projection clause.");
            }
            keepMode = true;
        }
        this.mRetainFields = Boolean.TRUE.equals(keepMode);
        this.mFields = Collections.unmodifiableSet(projection.keySet());
    }

    public IONObject project(IONObject object) {
        IONObjectId id = object.getIONObjectId(ID_KEY);
        boolean keepId = id != null && this.mIncludeId;
        Set<String> retainedKeys = null;
        if (this.mRetainFields) {
            retainedKeys = this.mFields;
        } else {
            retainedKeys = new HashSet(object.keySet());
            retainedKeys.removeAll(this.mFields);
        }
        IONObject newObj = new IONObject();
        if (keepId) {
            newObj.put(ID_KEY, id);
        }
        for (String retainedKey : retainedKeys) {
            FieldSelector selector;
            IONArtifact container;
            if (retainedKey.equals(ID_KEY) || !((container = (selector = new FieldSelector(retainedKey)).getFieldContainer(newObj, true)) instanceof IONObject)) continue;
            IONObject obj = (IONObject)container;
            String fieldKey = selector.getTailingCrumb();
            obj.put(fieldKey, selector.getFieldValue(object));
        }
        return newObj;
    }

    private static enum UnsupportedProjectionOperators {
        $,
        $elemMatch,
        $meta,
        $slice;

    }
}

