/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.query;

import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.AndOperator;
import com.ibm.neo.persist.query.BooleanOperator;
import com.ibm.neo.persist.query.ComparableRegex;
import com.ibm.neo.persist.query.ComparisonOperator;
import com.ibm.neo.persist.query.ExistsOperator;
import com.ibm.neo.persist.query.InOperator;
import com.ibm.neo.persist.query.InvalidQueryException;
import com.ibm.neo.persist.query.NorOperator;
import com.ibm.neo.persist.query.NotExistsOperator;
import com.ibm.neo.persist.query.NotInOperator;
import com.ibm.neo.persist.query.NotOperator;
import com.ibm.neo.persist.query.OrOperator;
import com.ibm.neo.persist.query.QueryOperator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class QueryParser {
    public static QueryOperator parseQuery(IONObject query) {
        if (query == null || query.isEmpty()) {
            return new BooleanOperator(true);
        }
        LinkedList<QueryOperator> operators = new LinkedList<QueryOperator>();
        try {
            block15: for (String key : query.keySet()) {
                Operator op;
                Comparable value = (Comparable)query.get(key);
                IONObject ionValue = null;
                try {
                    op = Operator.valueOf(key);
                }
                catch (IllegalArgumentException e) {
                    if (value instanceof IONObject) {
                        ionValue = QueryParser.castToIONObject(value);
                        String firstOperandKey = (String)ionValue.keySet().iterator().next();
                        try {
                            op = Operator.valueOf(firstOperandKey);
                        }
                        catch (IllegalArgumentException f) {
                            throw new InvalidQueryException.InvalidQueryClause(query, "Unknown operator.");
                        }
                        value = (Comparable)ionValue.get(firstOperandKey);
                    }
                    op = Operator.EQ;
                }
                switch (op) {
                    case EQ: 
                    case $ne: 
                    case $gt: 
                    case $gte: 
                    case $lt: 
                    case $lte: {
                        operators.add(new ComparisonOperator(op, key, value));
                        continue block15;
                    }
                    case $regex: {
                        int options = 0;
                        if (ionValue.containsKey("$options")) {
                            String optionsStr = ionValue.getString("$options");
                            if (optionsStr.contains("i")) {
                                options |= 0x42;
                            }
                            if (optionsStr.contains("m")) {
                                options |= 8;
                            }
                            if (optionsStr.contains("x")) {
                                options |= 4;
                            }
                        }
                        Pattern pattern = Pattern.compile((String)((Object)value), options);
                        operators.add(new ComparisonOperator(op, key, new ComparableRegex(pattern)));
                        continue block15;
                    }
                    case $and: 
                    case $or: 
                    case $nor: {
                        operators.add(QueryParser.parseLogicalOperator(query, op, value));
                        continue block15;
                    }
                    case $not: {
                        operators.add(new NotOperator(QueryParser.parseQuery(QueryParser.castToIONObject(value))));
                        continue block15;
                    }
                    case $in: {
                        operators.add(new InOperator(key, QueryParser.castToListOfComparables(value)));
                        continue block15;
                    }
                    case $nin: {
                        operators.add(new NotInOperator(key, QueryParser.castToListOfComparables(value)));
                        continue block15;
                    }
                    case $exists: {
                        if (((Boolean)value).booleanValue()) {
                            operators.add(new ExistsOperator(key));
                            continue block15;
                        }
                        operators.add(new NotExistsOperator(key));
                        continue block15;
                    }
                }
                throw new InvalidQueryException.UnsupportedQueryClause(op);
            }
        }
        catch (ClassCastException e) {
            throw new InvalidQueryException.InvalidQueryClause(query, e.getLocalizedMessage());
        }
        if (operators.size() == 1) {
            return (QueryOperator)operators.get(0);
        }
        return new AndOperator(operators);
    }

    private static QueryOperator parseLogicalOperator(IONObject query, Operator op, Comparable<?> value) {
        if (!(value instanceof IONArray)) {
            throw new InvalidQueryException.InvalidQueryClause(query, "value for " + (Object)((Object)op) + " must be an array.");
        }
        IONArray conditionArray = (IONArray)value;
        LinkedList<QueryOperator> conditions = new LinkedList<QueryOperator>();
        for (Object element : conditionArray) {
            conditions.add(QueryParser.parseQuery(QueryParser.castToIONObject(element)));
        }
        switch (op) {
            case $and: {
                return new AndOperator(conditions);
            }
            case $or: {
                return new OrOperator(conditions);
            }
            case $nor: {
                return new NorOperator(conditions);
            }
        }
        throw new InvalidQueryException.UnsupportedQueryClause(op);
    }

    private static List<Comparable<?>> castToListOfComparables(Comparable<?> object) {
        if (!(object instanceof IONArray)) {
            throw new InvalidQueryException.InvalidQueryClause("Object " + object.toString() + " is not an array (IONArray).");
        }
        IONArray array = (IONArray)object;
        LinkedList list = new LinkedList();
        for (Object element : array) {
            try {
                String strElement;
                if (element instanceof String && (strElement = (String)element).startsWith("/") && strElement.endsWith("/")) {
                    element = new ComparableRegex(Pattern.compile(strElement.substring(1, strElement.length() - 1)));
                }
                list.add((Comparable)element);
            }
            catch (ClassCastException e) {
                throw new InvalidQueryException.InvalidQueryClause("Array " + array.toString() + " contains elements which are not comparable.");
            }
        }
        return list;
    }

    private static IONObject castToIONObject(Object object) {
        if (!(object instanceof IONObject)) {
            throw new InvalidQueryException.InvalidQueryClause("Object " + object.toString() + " is not a document (IONObject).");
        }
        return (IONObject)object;
    }

    static enum Operator {
        $gt,
        $gte,
        $in,
        $lt,
        $lte,
        $ne,
        $nin,
        $or,
        $and,
        $not,
        $nor,
        $exists,
        $type,
        $mod,
        $regex,
        $text,
        $where,
        $geoWithin,
        $geoIntersects,
        $near,
        $nearSphere,
        $,
        $elemMatch,
        $meta,
        $slice,
        EQ;

    }
}

