/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.query;

import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.FieldSelector;
import com.ibm.neo.persist.query.InvalidQueryException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class SortEvaluator {
    public static Comparator<IONObject> buildComparator(IONObject sort) {
        return new SortComparator(sort);
    }

    private static class SortComparator
    implements Comparator<IONObject> {
        private final List<Clause> mClauses = new LinkedList<Clause>();

        private SortComparator(IONObject sort) {
            for (String sortField : sort.keySet()) {
                try {
                    this.mClauses.add(new Clause(sortField, sort.getInt(sortField)));
                }
                catch (ClassCastException e) {
                    throw new InvalidQueryException.InvalidSortClause(sort, "The field '" + sortField + "' has an invalid value.");
                }
            }
            if (this.mClauses.isEmpty()) {
                throw new InvalidQueryException.InvalidSortClause(sort, "There are no sort clauses.");
            }
        }

        @Override
        public int compare(IONObject left, IONObject right) {
            Clause clause;
            int sortResult = 0;
            Iterator<Clause> i$ = this.mClauses.iterator();
            while (i$.hasNext() && (sortResult = (clause = i$.next()).compare(left, right)) == 0) {
            }
            return sortResult;
        }

        private static class Clause
        implements Comparator<IONObject> {
            private final FieldSelector mSelector;
            private final int mDirection;

            private Clause(String field, int direction) {
                this.mSelector = new FieldSelector(field);
                this.mDirection = direction;
            }

            @Override
            public int compare(IONObject left, IONObject right) {
                Object leftFieldValue = this.mSelector.getFieldValue(left);
                Object rightFieldValue = this.mSelector.getFieldValue(right);
                if (leftFieldValue == null) {
                    if (rightFieldValue == null) {
                        return 0;
                    }
                    return this.mDirection * -1;
                }
                if (rightFieldValue == null) {
                    return this.mDirection;
                }
                int compareResult = ((Comparable)leftFieldValue).compareTo(rightFieldValue);
                return this.mDirection * compareResult;
            }
        }
    }
}

