/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.queue.api;

import com.ibm.neo.persist.queue.api.DistributedEventException;
import com.ibm.neo.persist.queue.api.DistributedEvents;
import com.ibm.neo.persist.queue.api.NoDistributedEvents;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class DistributedEventsProvider {
    private DistributedEvents m_distributedEvents;

    public DistributedEventsProvider() throws DistributedEventException {
        this(null);
    }

    public DistributedEventsProvider(String _name) throws DistributedEventException {
        ServiceLoader<DistributedEvents> serviceLoader = ServiceLoader.load(DistributedEvents.class);
        try {
            Iterator<DistributedEvents> events = serviceLoader.iterator();
            while (this.m_distributedEvents == null && events.hasNext()) {
                DistributedEvents eventsImpl = events.next();
                if (_name == null || !_name.equals(eventsImpl.name())) continue;
                this.m_distributedEvents = eventsImpl;
            }
        }
        catch (ServiceConfigurationError serviceError) {
            throw new DistributedEventException(serviceError);
        }
        finally {
            if (this.m_distributedEvents == null) {
                this.m_distributedEvents = new NoDistributedEvents();
            }
        }
    }

    public DistributedEvents service() {
        return this.m_distributedEvents;
    }
}

