/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.slice;

import com.ibm.neo.persist.ECursorOption;
import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.cursor.EmptyCursor;
import com.ibm.neo.persist.cursor.FieldProjectingCursor;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.slice.ISlicer;
import com.ibm.neo.persist.slice.SlicerHelper;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SlicedCursor
implements ICursor<IONObject> {
    private final ICursor<IONObject> mCursorImpl;
    private final ISlicer mSlicer;
    private boolean mValid;

    public SlicedCursor(ICursor<IONObject> cursor, ISlicer slicer) throws PersistenceException.SliceBoundary {
        if (slicer.getKey() == null || slicer.getKey().isEmpty()) {
            throw new IllegalArgumentException("The slicer key is not expected to be '" + slicer.getKey() + "'.");
        }
        if (slicer.getValue() == null) {
            throw new IllegalArgumentException("The slicer value is not expected to be null.");
        }
        this.mCursorImpl = cursor;
        this.mSlicer = slicer;
        this.mValid = true;
    }

    @Override
    public boolean supportsOption(ECursorOption option) throws PersistenceException {
        return this.mCursorImpl.supportsOption(option);
    }

    @Override
    public EnumSet<ECursorOption> getOptions() throws PersistenceException {
        return this.mCursorImpl.getOptions();
    }

    @Override
    public ICursor<IONObject> setOptions(EnumSet<ECursorOption> options) throws PersistenceException {
        this.mCursorImpl.setOptions(options);
        return this;
    }

    @Override
    public boolean supportsMaxTime() throws PersistenceException {
        return this.mCursorImpl.supportsMaxTime();
    }

    @Override
    public ICursor<IONObject> maxTime(long maxTime, TimeUnit timeUnit) throws PersistenceException {
        this.mCursorImpl.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public ICursor<IONObject> setReadPreference(EReadPreference readPref) throws PersistenceException {
        this.mCursorImpl.setReadPreference(readPref);
        return this;
    }

    @Override
    public void close() throws PersistenceException {
        this.mCursorImpl.close();
    }

    @Override
    public int count() throws PersistenceException {
        return this.mCursorImpl.count();
    }

    @Override
    public IONObject current() throws PersistenceException {
        if (this.mValid) {
            return this.mCursorImpl.current();
        }
        return null;
    }

    @Override
    public boolean hasNext() throws PersistenceException {
        return this.mValid && this.mCursorImpl.hasNext();
    }

    @Override
    public IONObject next() throws PersistenceException {
        if (this.mValid) {
            try {
                return SlicerHelper.validateAndRemoveSlicer(this.mCursorImpl.next(), this.mSlicer);
            }
            catch (PersistenceException.SliceBoundary e) {
                this.mValid = false;
                throw e;
            }
        }
        return null;
    }

    @Override
    public ICursor<IONObject> sort(IONObject orderBy) throws PersistenceException {
        this.mCursorImpl.sort(orderBy);
        return this;
    }

    @Override
    public ICursor<IONObject> sortNatural(ESortOrder order) throws PersistenceException {
        this.mCursorImpl.sortNatural(order);
        return this;
    }

    @Override
    public ICursor<IONObject> limit(int limit) throws PersistenceException {
        this.mCursorImpl.limit(limit);
        return this;
    }

    @Override
    public <U> ICursor<U> project(String fieldName, Class<U> fieldType) throws PersistenceException {
        if (fieldName == this.mSlicer.getKey()) {
            return new EmptyCursor();
        }
        return new FieldProjectingCursor<U>(this, fieldName, fieldType);
    }

    @Override
    public List<IONObject> toListAndClose() throws PersistenceException {
        List<IONObject> result = this.mCursorImpl.toListAndClose();
        if (result != null) {
            for (IONObject ion : result) {
                SlicerHelper.validateAndRemoveSlicer(ion, this.mSlicer);
            }
        }
        return result;
    }
}

