/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.slice;

import com.ibm.neo.persist.AbstractDocumentCollection;
import com.ibm.neo.persist.AggregationPipelineBuilder;
import com.ibm.neo.persist.ECursorOption;
import com.ibm.neo.persist.EReadPreference;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.EWriteConcern;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.IPersistenceGateway;
import com.ibm.neo.persist.IndexInfo;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.slice.ISlicer;
import com.ibm.neo.persist.slice.SlicedCursor;
import com.ibm.neo.persist.slice.SlicedDocumentDatabase;
import com.ibm.neo.persist.slice.SlicerHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;

public class SlicedDocumentCollection
extends AbstractDocumentCollection {
    private final SlicedDocumentDatabase mDatabase;
    private final IDocumentCollection mSourceCol;
    private final ISlicer mSlicer;

    public SlicedDocumentCollection(SlicedDocumentDatabase database, IDocumentCollection sourceCol, ISlicer slicer) throws PersistenceException {
        this.mDatabase = database;
        this.mSourceCol = sourceCol;
        this.mSlicer = slicer;
        this.mSourceCol.ensureSortedIndex(new String[]{this.mSlicer.getKey()}, new ESortOrder[]{ESortOrder.ASCENDING}, false, false);
    }

    private String getSliceIndexName() {
        return this.mSlicer.getKey() + "_1";
    }

    @Override
    public <T> T getCollectionImpl(Class<T> type) {
        return type.cast(this.mSourceCol);
    }

    @Override
    public IPersistenceGateway getGateway() {
        return this.mSourceCol.getGateway();
    }

    @Override
    public IDocumentDatabase getDatabase() {
        return this.mDatabase;
    }

    @Override
    public String getName() {
        return this.mSourceCol.getName();
    }

    @Override
    public String getFullName() {
        return this.mSourceCol.getFullName();
    }

    @Override
    public List<IndexInfo> getIndexInfo() throws PersistenceException {
        if (SlicerHelper.useLegacyIndexes()) {
            return this.getLegacyIndexInfo();
        }
        return this.getNewIndexInfo();
    }

    private List<IndexInfo> getLegacyIndexInfo() throws PersistenceException {
        List<IndexInfo> sourceIndexInfo = this.mSourceCol.getIndexInfo();
        ArrayList<IndexInfo> slicedIndexInfo = new ArrayList<IndexInfo>(sourceIndexInfo.size());
        String sliceIndexName = this.getSliceIndexName();
        for (IndexInfo indexInfo : sourceIndexInfo) {
            if (sliceIndexName.equals(indexInfo.getName())) continue;
            String[] keys = indexInfo.getKeys();
            ESortOrder[] orders = indexInfo.getSortOrders();
            if (keys.length > 1 && this.mSlicer.getKey().equals(keys[keys.length - 1])) {
                String[] slicedKeys = Arrays.copyOf(keys, keys.length - 1);
                ESortOrder[] slicedOrders = null;
                slicedOrders = null != orders && orders.length > 1 ? Arrays.copyOf(orders, orders.length - 1) : new ESortOrder[]{};
                slicedIndexInfo.add(new IndexInfo(indexInfo.getName(), slicedKeys, slicedOrders, indexInfo.isHashed(), indexInfo.isUnique(), indexInfo.isSparse(), indexInfo.getExpireAfterSeconds()));
                continue;
            }
            slicedIndexInfo.add(indexInfo);
        }
        return slicedIndexInfo;
    }

    private List<IndexInfo> getNewIndexInfo() throws PersistenceException {
        List<IndexInfo> sourceIndexInfo = this.mSourceCol.getIndexInfo();
        ArrayList<IndexInfo> slicedIndexInfo = new ArrayList<IndexInfo>(sourceIndexInfo.size());
        String sliceIndexName = this.getSliceIndexName();
        for (IndexInfo indexInfo : sourceIndexInfo) {
            if (sliceIndexName.equals(indexInfo.getName())) continue;
            String[] keys = indexInfo.getKeys();
            ESortOrder[] orders = indexInfo.getSortOrders();
            if (keys.length > 1 && this.mSlicer.getKey().equals(keys[0])) {
                String[] slicedKeys = Arrays.copyOfRange(keys, 1, keys.length);
                ESortOrder[] slicedOrders = null;
                slicedOrders = null != orders && orders.length > 1 ? Arrays.copyOfRange(orders, 1, orders.length) : new ESortOrder[]{};
                slicedIndexInfo.add(new IndexInfo(indexInfo.getName(), slicedKeys, slicedOrders, indexInfo.isHashed(), indexInfo.isUnique(), indexInfo.isSparse(), indexInfo.getExpireAfterSeconds()));
                continue;
            }
            slicedIndexInfo.add(indexInfo);
        }
        return slicedIndexInfo;
    }

    @Override
    public void ensureSortedIndex(String[] keys, ESortOrder[] sortOrders, boolean isUnique, boolean isSparse) throws PersistenceException {
        if (ArrayUtils.contains((Object[])keys, (Object)this.mSlicer.getKey())) {
            throw new IllegalArgumentException("Index must not reference slicer key: " + this.mSlicer.getKey());
        }
        if (isUnique) {
            if (SlicerHelper.useLegacyIndexes()) {
                String[] newKeys = Arrays.copyOf(keys, keys.length + 1);
                ESortOrder[] newSortOrders = Arrays.copyOf(sortOrders, sortOrders.length + 1);
                newKeys[keys.length] = this.mSlicer.getKey();
                newSortOrders[sortOrders.length] = ESortOrder.ASCENDING;
                this.mSourceCol.ensureSortedIndex(newKeys, newSortOrders, isUnique, isSparse);
            } else {
                String[] newKeys = new String[keys.length + 1];
                ESortOrder[] newSortOrders = new ESortOrder[sortOrders.length + 1];
                System.arraycopy(keys, 0, newKeys, 1, keys.length);
                System.arraycopy(sortOrders, 0, newSortOrders, 1, sortOrders.length);
                newKeys[0] = this.mSlicer.getKey();
                newSortOrders[0] = ESortOrder.ASCENDING;
                this.mSourceCol.ensureSortedIndex(newKeys, newSortOrders, isUnique, isSparse);
            }
        } else {
            this.mSourceCol.ensureSortedIndex(keys, sortOrders, isUnique, isSparse);
        }
    }

    @Override
    public void ensureHashedIndex(String key, boolean isUnique, boolean isSparse) throws PersistenceException {
        throw new UnsupportedOperationException("Hashed indexes are not supported for sliced collections");
    }

    @Override
    public void ensureTTLIndex(String key, int expireAfterSeconds) throws PersistenceException {
        this.mSourceCol.ensureTTLIndex(key, expireAfterSeconds);
    }

    @Override
    public void dropIndex(String indexName) throws PersistenceException {
        if (!this.getSliceIndexName().equals(indexName)) {
            this.mSourceCol.dropIndex(indexName);
        }
    }

    @Override
    public void dropIndexes() throws PersistenceException {
        for (IndexInfo index : this.getIndexInfo()) {
            try {
                this.dropIndex(index.getName());
            }
            catch (PersistenceException persistenceException) {}
        }
    }

    @Override
    public boolean isCapped() throws PersistenceException {
        return this.mSourceCol.isCapped();
    }

    @Override
    public boolean supportsCursorOption(ECursorOption option) throws PersistenceException {
        return this.mSourceCol.supportsCursorOption(option);
    }

    @Override
    public boolean supportsCursorMaxTime() throws PersistenceException {
        return this.mSourceCol.supportsCursorMaxTime();
    }

    @Override
    public boolean supportsAggregate() throws PersistenceException {
        return this.mSourceCol.supportsAggregate();
    }

    @Override
    public IONObject get(IONObjectId id, EReadPreference readPref) throws PersistenceException {
        IONObject query = new QueryBuilder().idEqualTo(id).toDocument();
        return this.findOne(query, readPref);
    }

    @Override
    public IONObject get(IONObjectId id, IONObject projection, EReadPreference readPref) throws PersistenceException {
        IONObject query = new QueryBuilder().idEqualTo(id).toDocument();
        return this.findOne(query, projection, readPref);
    }

    @Override
    public long count(EReadPreference readPref) throws PersistenceException {
        return this.count(null, readPref);
    }

    @Override
    public long count(IONObject query, EReadPreference readPref) throws PersistenceException {
        SlicerHelper.checkForSlicer(query, this.mSlicer);
        return this.mSourceCol.count(SlicerHelper.withFilter(query, this.mSlicer), readPref);
    }

    @Override
    public ICursor<IONObject> find(IONObject query) throws PersistenceException {
        SlicerHelper.checkForSlicer(query, this.mSlicer);
        ICursor<IONObject> sourceCur = this.mSourceCol.find(SlicerHelper.withFilter(query, this.mSlicer));
        return new SlicedCursor(sourceCur, this.mSlicer);
    }

    @Override
    public IONArray aggregate(List<IONObject> pipelines, EReadPreference readPref) throws PersistenceException {
        if (pipelines == null || pipelines.size() == 0) {
            return new IONArray(0);
        }
        for (IONObject piplineIon : pipelines) {
            SlicerHelper.checkForSlicer(piplineIon, this.mSlicer);
        }
        AggregationPipelineBuilder builder = new AggregationPipelineBuilder(pipelines);
        IONObject firstMatch = builder.get(AggregationPipelineBuilder.PipelineCmd.$match, 0);
        if (firstMatch == null) {
            builder.match(SlicerHelper.withFilter(new IONObject(), this.mSlicer), true);
        } else {
            builder.replace(AggregationPipelineBuilder.PipelineCmd.$match, 0, SlicerHelper.withFilter(firstMatch, this.mSlicer));
        }
        return this.mSourceCol.aggregate(builder.toIONDocuments(), readPref);
    }

    @Override
    public ICursor<IONObject> find(IONObject query, IONObject projection) throws PersistenceException {
        SlicerHelper.checkForSlicer(this.mSlicer, query, projection);
        ICursor<IONObject> sourceCur = this.mSourceCol.find(SlicerHelper.withFilter(query, this.mSlicer), SlicerHelper.withProjection(projection, this.mSlicer));
        return new SlicedCursor(sourceCur, this.mSlicer);
    }

    @Override
    public ICursor<IONObject> findAll() throws PersistenceException {
        ICursor<IONObject> sourceCur = this.mSourceCol.find(SlicerHelper.makeFilter(this.mSlicer));
        return new SlicedCursor(sourceCur, this.mSlicer);
    }

    @Override
    public ICursor<IONObject> findAll(IONObject projection) throws PersistenceException {
        SlicerHelper.checkForSlicer(projection, this.mSlicer);
        ICursor<IONObject> sourceCur = this.mSourceCol.find(SlicerHelper.makeFilter(this.mSlicer), SlicerHelper.withProjection(projection, this.mSlicer));
        return new SlicedCursor(sourceCur, this.mSlicer);
    }

    @Override
    public IONObject findOne(IONObject query, EReadPreference readPref) throws PersistenceException {
        SlicerHelper.checkForSlicer(query, this.mSlicer);
        IONObject ion = this.mSourceCol.findOne(SlicerHelper.withFilter(query, this.mSlicer), readPref);
        return SlicerHelper.validateAndRemoveSlicer(ion, this.mSlicer);
    }

    @Override
    public IONObject findOne(IONObject query, IONObject projection, EReadPreference readPref) throws PersistenceException {
        SlicerHelper.checkForSlicer(this.mSlicer, query, projection);
        IONObject ion = this.mSourceCol.findOne(SlicerHelper.withFilter(query, this.mSlicer), SlicerHelper.withProjection(projection, this.mSlicer), readPref);
        return SlicerHelper.validateAndRemoveSlicer(ion, this.mSlicer);
    }

    @Override
    public boolean remove(IONObjectId id, EWriteConcern writeConcern) throws PersistenceException {
        IONObject query = new QueryBuilder().idEqualTo(id).toDocument();
        return this.remove(query, writeConcern) > 0;
    }

    @Override
    public int remove(IONObject query, EWriteConcern writeConcern) throws PersistenceException {
        SlicerHelper.checkForSlicer(query, this.mSlicer);
        return this.mSourceCol.remove(SlicerHelper.withFilter(query, this.mSlicer), writeConcern);
    }

    @Override
    public void save(IONObject doc, EWriteConcern writeConcern) throws PersistenceException {
        SlicerHelper.checkForSlicer(doc, this.mSlicer);
        SlicerHelper.insertFilter(doc, this.mSlicer);
        this.mSourceCol.save(doc, writeConcern);
        SlicerHelper.removeFilter(doc, this.mSlicer);
    }

    @Override
    public void insert(IONObject doc, EWriteConcern writeConcern) throws PersistenceException {
        SlicerHelper.checkForSlicer(doc, this.mSlicer);
        SlicerHelper.insertFilter(doc, this.mSlicer);
        this.mSourceCol.insert(doc, writeConcern);
        SlicerHelper.removeFilter(doc, this.mSlicer);
    }

    @Override
    public void insert(Collection<IONObject> docs, EWriteConcern writeConcern) throws PersistenceException {
        for (IONObject doc : docs) {
            SlicerHelper.checkForSlicer(doc, this.mSlicer);
            SlicerHelper.insertFilter(doc, this.mSlicer);
        }
        this.mSourceCol.insert(docs, writeConcern);
        for (IONObject doc : docs) {
            SlicerHelper.removeFilter(doc, this.mSlicer);
        }
    }

    @Override
    public int update(IONObjectId id, IONObject update, EWriteConcern writeConcern) throws PersistenceException {
        IONObject query = new QueryBuilder().idEqualTo(id).toDocument();
        return this.update(query, update, false, false, writeConcern);
    }

    @Override
    public int update(IONObject query, IONObject update, boolean upsert, boolean multi, EWriteConcern writeConcern) throws PersistenceException {
        SlicerHelper.checkForSlicer(this.mSlicer, query, update);
        return this.mSourceCol.update(SlicerHelper.withFilter(query, this.mSlicer), SlicerHelper.insertUpdate(update, upsert, this.mSlicer), upsert, multi, writeConcern);
    }

    @Override
    public IONObject findOneAndUpdate(IONObject query, IONObject sort, IONObject update, IONObject projection, boolean returnNew, boolean upsert) throws PersistenceException {
        SlicerHelper.checkForSlicer(this.mSlicer, query, update, projection);
        IONObject result = this.mSourceCol.findOneAndUpdate(SlicerHelper.withFilter(query, this.mSlicer), sort, SlicerHelper.insertUpdate(update, upsert, this.mSlicer), SlicerHelper.withProjection(projection, this.mSlicer), returnNew, upsert);
        return SlicerHelper.validateAndRemoveSlicer(result, this.mSlicer);
    }

    @Override
    public IONObject findOneAndRemove(IONObject query, IONObject sort, IONObject projection) throws PersistenceException {
        SlicerHelper.checkForSlicer(this.mSlicer, query, projection);
        IONObject result = this.mSourceCol.findOneAndRemove(SlicerHelper.withFilter(query, this.mSlicer), sort, SlicerHelper.withProjection(projection, this.mSlicer));
        return SlicerHelper.validateAndRemoveSlicer(result, this.mSlicer);
    }

    @Override
    public <T> T findOneAndProject(IONObject query, String fieldToProject, Class<T> fieldType, EReadPreference readPref) throws PersistenceException {
        SlicerHelper.checkForSlicer(query, this.mSlicer);
        if (fieldToProject != null && fieldToProject == this.mSlicer.getKey()) {
            return null;
        }
        return this.mSourceCol.findOneAndProject(SlicerHelper.withFilter(query, this.mSlicer), fieldToProject, fieldType, readPref);
    }

    @Override
    public <T> List<T> distinct(String field, Class<T> fieldType, EReadPreference readPref) throws PersistenceException {
        return this.distinct(new IONObject(), field, fieldType, readPref);
    }

    @Override
    public <T> List<T> distinct(IONObject query, String field, Class<T> fieldType, EReadPreference readPref) throws PersistenceException {
        SlicerHelper.checkForSlicer(query, this.mSlicer);
        if (field != null && field == this.mSlicer.getKey()) {
            return new ArrayList(0);
        }
        return this.mSourceCol.distinct(SlicerHelper.withFilter(query, this.mSlicer), field, fieldType, readPref);
    }

    @Override
    public void drop() throws PersistenceException {
        this.notifyDropped();
        this.mSourceCol.remove(SlicerHelper.makeFilter(this.mSlicer));
    }
}

