/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.slice;

import com.ibm.neo.persist.ICatalog;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.IDropListener;
import com.ibm.neo.persist.IFileBucket;
import com.ibm.neo.persist.IPersistenceGateway;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.persist.nobject.NonPolymorphicNobjectCollection;
import com.ibm.neo.persist.slice.ISlicer;
import com.ibm.neo.persist.slice.SlicedDocumentCollection;
import com.ibm.neo.persist.slice.SlicedFileBucket;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SlicedDocumentDatabase
implements IDocumentDatabase {
    private final IDocumentDatabase mSourceDb;
    private final ISlicer mSlicer;
    private final List<IDropListener> mDropListeners = new LinkedList<IDropListener>();
    private final ConcurrentHashMap<String, IDocumentCollection> mName2Collection = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, IFileBucket> mName2FileBucket = new ConcurrentHashMap();

    public SlicedDocumentDatabase(IDocumentDatabase sourceDb, ISlicer slicer) {
        this.mSourceDb = sourceDb;
        this.mSlicer = slicer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDropListener(IDropListener listener) {
        List<IDropListener> list = this.mDropListeners;
        synchronized (list) {
            this.mDropListeners.add(listener);
        }
    }

    @Override
    public <T> T getDatabaseImpl(Class<T> type) {
        return type.cast(this.mSourceDb);
    }

    @Override
    public IPersistenceGateway getGateway() {
        return this.mSourceDb.getGateway();
    }

    @Override
    public ICatalog getCatalog() {
        return this.mSourceDb.getCatalog();
    }

    @Override
    public String getName() {
        return this.mSourceDb.getName();
    }

    @Override
    public boolean supportsCappedCollections() {
        return false;
    }

    @Override
    public boolean collectionExists(String collectionName) throws PersistenceException {
        return this.mSourceDb.collectionExists(collectionName);
    }

    @Override
    public Set<String> getCollectionNames() throws PersistenceException {
        return this.mSourceDb.getCollectionNames();
    }

    @Override
    public List<IDocumentCollection> listDocumentCollections() throws PersistenceException {
        Set<String> collectionNames = this.getCollectionNames();
        ArrayList<IDocumentCollection> slicedCollections = new ArrayList<IDocumentCollection>(collectionNames.size());
        for (String name : collectionNames) {
            slicedCollections.add(this.getDocumentCollection(name));
        }
        return slicedCollections;
    }

    @Override
    public IDocumentCollection getDocumentCollection(String collectionName) throws PersistenceException {
        IDocumentCollection col = this.mName2Collection.get(collectionName);
        if (null == col) {
            col = new SlicedDocumentCollection(this, this.mSourceDb.getDocumentCollection(collectionName), this.mSlicer);
            col.addDropListener(new IDropListener(){

                @Override
                public void onDropped(Object o) {
                    IDocumentCollection col = (IDocumentCollection)o;
                    SlicedDocumentDatabase.this.mName2Collection.remove(col.getName(), col);
                }
            });
            IDocumentCollection conflict = this.mName2Collection.putIfAbsent(collectionName, col);
            if (null != conflict) {
                col = conflict;
            }
        }
        return col;
    }

    @Override
    public IDocumentCollection getCappedDocumentCollection(String collectionName, int maxSizeInBytes, int maxDocuments) throws PersistenceException {
        throw new UnsupportedOperationException("Capped collections are not supported in the shared database model.");
    }

    @Override
    public Set<String> getFileBucketNames() throws PersistenceException {
        return this.mSourceDb.getFileBucketNames();
    }

    @Override
    public IFileBucket getFileBucket(String bucketName) throws PersistenceException {
        IFileBucket bucket = this.mName2FileBucket.get(bucketName);
        if (null == bucket) {
            bucket = new SlicedFileBucket(this, this.mSourceDb.getFileBucket(bucketName), this.mSlicer);
            bucket.addDropListener(new IDropListener(){

                @Override
                public void onDropped(Object o) {
                    IFileBucket bucket = (IFileBucket)o;
                    SlicedDocumentDatabase.this.mName2FileBucket.remove(bucket.getBucketName(), bucket);
                }
            });
            IFileBucket conflict = this.mName2FileBucket.putIfAbsent(bucketName, bucket);
            if (null != conflict) {
                bucket = conflict;
            }
        }
        return bucket;
    }

    @Override
    public List<IFileBucket> listFileBuckets() throws PersistenceException {
        Set<String> bucketNames = this.getFileBucketNames();
        ArrayList<IFileBucket> buckets = new ArrayList<IFileBucket>(bucketNames.size());
        for (String name : bucketNames) {
            buckets.add(this.getFileBucket(name));
        }
        return buckets;
    }

    @Override
    public <T extends Nobject> NobjectCollection<T> getNobjectCollection(String collectionName, Class<T> nobjectType) throws PersistenceException {
        return new NobjectCollection<T>(this.getDocumentCollection(collectionName), nobjectType);
    }

    @Override
    public <T extends Nobject> NobjectCollection<T> getNonPolymorphicNobjectCollection(String collectionName, Class<T> nobjectType) throws PersistenceException {
        return new NonPolymorphicNobjectCollection<T>(this.getDocumentCollection(collectionName), nobjectType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop() throws PersistenceException {
        List<IDropListener> list = this.mDropListeners;
        synchronized (list) {
            for (IDropListener listener : this.mDropListeners) {
                listener.onDropped(this);
            }
        }
        for (String colName : this.getCollectionNames()) {
            if (colName.endsWith(".files") || colName.endsWith(".chunks")) continue;
            IDocumentCollection col = this.getDocumentCollection(colName);
            col.drop();
        }
        for (String bucketName : this.getFileBucketNames()) {
            IFileBucket bucket = this.getFileBucket(bucketName);
            bucket.drop();
        }
        this.mName2Collection.clear();
        this.mName2FileBucket.clear();
    }

    ISlicer getSlicer() {
        return this.mSlicer;
    }
}

