/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.slice;

import com.ibm.neo.persist.ECursorOption;
import com.ibm.neo.persist.ESortOrder;
import com.ibm.neo.persist.ICursor;
import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.PersistenceService;
import com.ibm.neo.persist.ProjectionBuilder;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.SortBuilder;
import com.ibm.neo.persist.cursor.DelegatingIONObjectCursor;
import com.ibm.neo.persist.cursor.FilteringCursor;
import com.ibm.neo.persist.cursor.IteratorBackedCursor;
import com.ibm.neo.persist.cursor.ProjectingCursor;
import com.ibm.neo.persist.ion.IONIncTimestamp;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.query.FieldSelector;
import com.ibm.neo.persist.slice.ISlicer;
import com.ibm.neo.persist.slice.SlicedDocumentDatabase;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlicedDocumentDatabaseWriteMonitor {
    private static final String FIELD_TIMESTAMP = "ts";
    private static final String FIELD_OPERATION = "op";
    private static final String FIELD_NAMESPACE = "ns";
    private static final String FIELD_BODY = "o";
    private static final String FIELD_PATH_BODY_ID = "o._id";
    private static final String FIELD_UPDATE_QUERY = "o2";
    private static final String FIELD_PATH_UPDATE_ID = "o2._id";
    private static final String OPERATION_DELETE = "d";
    private static final String OPERATION_INSERT = "i";
    private static final String OPERATION_UPDATE = "u";
    private static final Logger LOG = LoggerFactory.getLogger(SlicedDocumentDatabaseWriteMonitor.class);
    private final SlicedDocumentDatabase sourceDb;
    private final SlicedDocumentDatabase deleteValidationDb;
    private final IDocumentCollection opLogCol;
    private IONIncTimestamp startingTimestamp;

    public static boolean canMonitorOpLog(PersistenceService ps) throws PersistenceException {
        return SlicedDocumentDatabaseWriteMonitor.getOpLog(ps, false) != null;
    }

    private static IDocumentCollection getOpLog(PersistenceService ps, boolean throwWhenMissing) throws PersistenceException {
        IDocumentCollection oplogCol = null;
        for (IDocumentCollection collection : ps.getDatabase("local").listDocumentCollections()) {
            if (!collection.getName().startsWith("oplog")) continue;
            if (oplogCol == null) {
                oplogCol = collection;
                continue;
            }
            if (throwWhenMissing) {
                throw new PersistenceException("Found more than one collection in the local database starting with 'oplog'.");
            }
            return null;
        }
        if (oplogCol == null && throwWhenMissing) {
            throw new PersistenceException("The local database does not have an oplog. Replication may not be supported or enabled.");
        }
        return oplogCol;
    }

    public SlicedDocumentDatabaseWriteMonitor(SlicedDocumentDatabase sourceDb, SlicedDocumentDatabase deleteValidationDb, PersistenceService ps) throws PersistenceException {
        this.sourceDb = sourceDb;
        this.deleteValidationDb = deleteValidationDb;
        this.opLogCol = SlicedDocumentDatabaseWriteMonitor.getOpLog(ps, true);
    }

    public void beginMonitoring() throws PersistenceException {
        List<IONObject> entries = this.opLogCol.findAll().sort(new SortBuilder().reverseNatural().toDocument()).limit(1).toListAndClose();
        if (entries.isEmpty()) {
            this.startingTimestamp = new IONIncTimestamp(0, 0);
        } else {
            this.startingTimestamp = entries.get(0).getIONIncTimestamp(FIELD_TIMESTAMP);
            if (this.startingTimestamp == null) {
                throw new PersistenceException("Documents in oplog collection are expected to have a 'ts' field.");
            }
        }
    }

    public boolean haveWritesOccurred() throws PersistenceException {
        if (this.startingTimestamp == null) {
            return false;
        }
        List<IONObject> opLogEvents = this.queryRawOpLog().toListAndClose();
        if (this.haveUpdatesOccurred(opLogEvents)) {
            return true;
        }
        if (this.haveDeletesOccurred(opLogEvents)) {
            return true;
        }
        ISlicer slicer = this.sourceDb.getSlicer();
        QueryBuilder insertsAndUpdatesQuery = new QueryBuilder().in(FIELD_OPERATION, OPERATION_INSERT, OPERATION_UPDATE).equalTo("o." + slicer.getKey(), slicer.getValue());
        List<IONObject> insertAndUpdateIds = this.filterOpLog(opLogEvents, insertsAndUpdatesQuery, new ProjectionBuilder().include(FIELD_PATH_BODY_ID, FIELD_NAMESPACE)).toListAndClose();
        if (!insertAndUpdateIds.isEmpty()) {
            LOG.warn("Documents matching slicer {} were created or modified in database {}:{}", new Object[]{slicer, this.sourceDb.getName(), insertAndUpdateIds});
            return true;
        }
        return false;
    }

    private boolean haveDeletesOccurred(List<IONObject> opLogEvents) throws PersistenceException {
        if (this.sourceDb.getName().equals(this.deleteValidationDb.getName())) {
            return false;
        }
        QueryBuilder deletesQuery = new QueryBuilder().equalTo(FIELD_OPERATION, OPERATION_DELETE);
        List<IONObject> allDeletes = this.filterOpLog(opLogEvents, deletesQuery, new ProjectionBuilder().include(FIELD_NAMESPACE, FIELD_BODY)).toListAndClose();
        return this.checkValidationDB(allDeletes, new FieldSelector(FIELD_PATH_BODY_ID), this.deleteValidationDb);
    }

    private boolean haveUpdatesOccurred(List<IONObject> opLogEvents) throws PersistenceException {
        QueryBuilder updatesQuery = new QueryBuilder().equalTo(FIELD_OPERATION, OPERATION_UPDATE);
        List<IONObject> allUpdates = this.filterOpLog(opLogEvents, updatesQuery, new ProjectionBuilder().include(FIELD_NAMESPACE, FIELD_UPDATE_QUERY)).toListAndClose();
        return this.checkValidationDB(allUpdates, new FieldSelector(FIELD_PATH_UPDATE_ID), this.sourceDb);
    }

    private ICursor<IONObject> filterOpLog(List<IONObject> opLogEvents, QueryBuilder query, ProjectionBuilder projection) throws PersistenceException {
        if (null == query) {
            query = new QueryBuilder();
        }
        query.regex(FIELD_NAMESPACE, this.databaseCollectionsNamespaceRegex(this.sourceDb), false, false, false);
        DelegatingIONObjectCursor cur = new FilteringCursor(new IteratorBackedCursor(opLogEvents.iterator()), query.toDocument());
        if (null != projection) {
            cur = new ProjectingCursor(cur, projection.toDocument());
        }
        return cur;
    }

    private ICursor<IONObject> queryRawOpLog() throws PersistenceException {
        IONObject tsFilter = new QueryBuilder().greaterThan(FIELD_TIMESTAMP, this.startingTimestamp).toDocument();
        return this.opLogCol.find(tsFilter).sortNatural(ESortOrder.ASCENDING).setOptions(EnumSet.of(ECursorOption.OPLOG_REPLAY));
    }

    private boolean checkValidationDB(List<IONObject> writeIds, FieldSelector documentIdField, IDocumentDatabase validationDb) throws PersistenceException {
        if (writeIds.isEmpty()) {
            return false;
        }
        Map<String, List<IONObjectId>> namespaceToDocIds = this.buildMapOfModifiedDocumentsByNamespace(writeIds, documentIdField);
        for (Map.Entry<String, List<IONObjectId>> entry : namespaceToDocIds.entrySet()) {
            IDocumentCollection collectionToCheck = this.getValidationCollectionFromNamespace(entry.getKey(), validationDb);
            if (collectionToCheck == null) continue;
            IONObject idsExistQuery = new QueryBuilder().in("_id", (Collection)entry.getValue()).toDocument();
            try {
                if (null == collectionToCheck.findOne(idsExistQuery, new ProjectionBuilder().includeId().toDocument())) continue;
                List<IONObjectId> docsThatExistInOtherDB = collectionToCheck.findAndProject(idsExistQuery, "_id", IONObjectId.class).toListAndClose();
                LOG.warn("Collection {} has documents that have been deleted or updated in source collection {}:{}", new Object[]{collectionToCheck.getFullName(), entry.getKey(), docsThatExistInOtherDB});
                return true;
            }
            catch (PersistenceException e) {
                LOG.warn("Unexpected error while querying {} with the clause {}.", (Object)collectionToCheck.getFullName(), (Object)idsExistQuery);
                throw e;
            }
        }
        return false;
    }

    private Map<String, List<IONObjectId>> buildMapOfModifiedDocumentsByNamespace(List<IONObject> opLogEntries, FieldSelector idSelector) throws PersistenceException {
        HashMap<String, List<IONObjectId>> namespaceToModifiedDocIds = new HashMap<String, List<IONObjectId>>();
        FieldSelector namespaceSelector = new FieldSelector(FIELD_NAMESPACE);
        for (IONObject opLogEntry : opLogEntries) {
            String collectionName = (String)namespaceSelector.getFieldValue(opLogEntry);
            IONObjectId documentId = (IONObjectId)idSelector.getFieldValue(opLogEntry);
            if (collectionName == null || documentId == null) {
                throw new PersistenceException(String.format("OpLog entry is expected to have a %s and a %s:%s", FIELD_NAMESPACE, idSelector.getTailingCrumb(), opLogEntry.toString()));
            }
            if (!namespaceToModifiedDocIds.containsKey(collectionName)) {
                namespaceToModifiedDocIds.put(collectionName, new LinkedList());
            }
            ((List)namespaceToModifiedDocIds.get(collectionName)).add(documentId);
        }
        return namespaceToModifiedDocIds;
    }

    private String databaseCollectionsNamespaceRegex(IDocumentDatabase db) {
        return String.format("^%s\\.[^$].*", db.getName());
    }

    private IDocumentCollection getValidationCollectionFromNamespace(String namespace, IDocumentDatabase validationDb) throws PersistenceException {
        String sourceDBNameDot = this.sourceDb.getName() + ".";
        if (namespace == null || !namespace.startsWith(sourceDBNameDot)) {
            return null;
        }
        String colName = namespace.substring(sourceDBNameDot.length());
        if (validationDb.collectionExists(colName)) {
            return validationDb.getDocumentCollection(colName);
        }
        return null;
    }
}

