/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.slice;

import com.ibm.neo.persist.IFile;
import com.ibm.neo.persist.IFileBucket;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.slice.ISlicer;
import com.ibm.neo.persist.slice.SlicedFileBucket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class SlicedFile
implements IFile {
    private final SlicedFileBucket mBucket;
    private final IFile mSourceFile;
    private final ISlicer mSlicer;

    public SlicedFile(SlicedFileBucket bucket, IFile sourceFile, ISlicer slicer) {
        this.mBucket = bucket;
        this.mSourceFile = sourceFile;
        this.mSlicer = slicer;
    }

    @Override
    public IFileBucket getBucket() {
        return this.mBucket;
    }

    @Override
    public IONObjectId getId() {
        return this.mSourceFile.getId();
    }

    @Override
    public String getFilename() {
        return this.mSourceFile.getFilename();
    }

    @Override
    public String getContentType() {
        return this.mSourceFile.getContentType();
    }

    @Override
    public long getLength() {
        return this.mSourceFile.getLength();
    }

    @Override
    public String getMD5() {
        return this.mSourceFile.getMD5();
    }

    @Override
    public Date getUploadDate() {
        return this.mSourceFile.getUploadDate();
    }

    @Override
    public Set<String> getMetadataKeys() {
        HashSet<String> keys = new HashSet<String>(this.mSourceFile.getMetadataKeys());
        keys.remove(this.mSlicer.getKey());
        return keys;
    }

    @Override
    public Object getMetadataValue(String key) {
        if (this.mSlicer.getKey().equals(key)) {
            return null;
        }
        return this.mSourceFile.getMetadataValue(key);
    }

    @Override
    public void setMetadataValue(String key, Object value) {
        if (this.mSlicer.getKey().equals(key)) {
            return;
        }
        this.mSourceFile.setMetadataValue(key, value);
    }

    @Override
    public Set<String> getKeys() {
        HashSet<String> keys = new HashSet<String>(this.mSourceFile.getKeys());
        keys.remove(this.mSlicer.getKey());
        return keys;
    }

    @Override
    public Object getValue(String key) {
        if (this.mSlicer.getKey().equals(key)) {
            return null;
        }
        return this.mSourceFile.getValue(key);
    }

    @Override
    public void setValue(String key, Object value) {
        if (this.mSlicer.getKey().equals(key)) {
            throw new IllegalArgumentException("Cannot set the slicer key: " + key);
        }
        this.mSourceFile.setValue(key, value);
    }

    @Override
    public InputStream open() throws PersistenceException {
        return this.mSourceFile.open();
    }

    @Override
    public long writeTo(OutputStream out) throws PersistenceException, IOException {
        return this.mSourceFile.writeTo(out);
    }

    @Override
    public long writeTo(File file) throws PersistenceException, IOException {
        return this.mSourceFile.writeTo(file);
    }

    @Override
    public void validate() throws PersistenceException {
        this.mSourceFile.validate();
    }

    @Override
    public void save() throws PersistenceException {
        this.mSourceFile.save();
    }

    public String toString() {
        return this.mSourceFile.toString();
    }

    public boolean equals(Object o) {
        return this.mSourceFile.equals(o);
    }

    public int hashCode() {
        return this.mSourceFile.hashCode();
    }
}

