/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.slice;

import com.ibm.neo.persist.IDocumentCollection;
import com.ibm.neo.persist.IDocumentDatabase;
import com.ibm.neo.persist.IDropListener;
import com.ibm.neo.persist.IFile;
import com.ibm.neo.persist.IFileBucket;
import com.ibm.neo.persist.IndexInfo;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.SortBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.slice.ISlicer;
import com.ibm.neo.persist.slice.SlicedDocumentDatabase;
import com.ibm.neo.persist.slice.SlicedFile;
import com.ibm.neo.persist.slice.SlicerHelper;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class SlicedFileBucket
implements IFileBucket {
    private final SlicedDocumentDatabase mDatabase;
    private final IFileBucket mSourceBucket;
    private final ISlicer mSlicer;
    private final List<IDropListener> mDropListeners = new LinkedList<IDropListener>();

    public SlicedFileBucket(SlicedDocumentDatabase database, IFileBucket sourceBucket, ISlicer slicer) throws PersistenceException {
        this.mDatabase = database;
        this.mSourceBucket = sourceBucket;
        this.mSlicer = slicer;
        this.rebuildGridFSIndexes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDropListener(IDropListener listener) {
        List<IDropListener> list = this.mDropListeners;
        synchronized (list) {
            this.mDropListeners.add(listener);
        }
    }

    @Override
    public IDocumentDatabase getDatabase() {
        return this.mDatabase;
    }

    @Override
    public String getBucketName() {
        return this.mSourceBucket.getBucketName();
    }

    @Override
    public IFile createFile(File file, String contentType) throws PersistenceException {
        IFile sourceFile = this.mSourceBucket.createFile(file, contentType);
        sourceFile.setValue(this.mSlicer.getKey(), this.mSlicer.getValue());
        sourceFile.save();
        return this.checkAndDecorateFile(sourceFile);
    }

    @Override
    public IFile createFile(InputStream in, String filename, String contentType) throws PersistenceException {
        IFile sourceFile = this.mSourceBucket.createFile(in, filename, contentType);
        sourceFile.setValue(this.mSlicer.getKey(), this.mSlicer.getValue());
        sourceFile.save();
        return this.checkAndDecorateFile(sourceFile);
    }

    @Override
    public IFile createOrReplaceFile(InputStream in, String filename, String contentType) throws PersistenceException {
        IFile newFile = this.createFile(in, filename, contentType);
        IONObject removeQuery = new QueryBuilder().equalTo("filename", filename).notEqualTo("_id", newFile.getId()).toDocument();
        this.remove(removeQuery);
        return newFile;
    }

    @Override
    public long count() throws PersistenceException {
        return this.mSourceBucket.count(SlicerHelper.makeFilter(this.mSlicer));
    }

    @Override
    public long count(IONObject query) throws PersistenceException {
        return this.mSourceBucket.count(SlicerHelper.withFilter(query, this.mSlicer));
    }

    @Override
    public IFile get(IONObjectId fileId) throws PersistenceException {
        return this.findOne(new QueryBuilder().equalTo("_id", fileId).toDocument());
    }

    @Override
    public List<IFile> findAll() throws PersistenceException {
        List<IFile> sourceFiles = this.mSourceBucket.find(SlicerHelper.makeFilter(this.mSlicer));
        return this.checkAndDecorateFiles(sourceFiles);
    }

    @Override
    public List<IFile> findAll(IONObject orderBy) throws PersistenceException {
        List<IFile> sourceFiles = this.mSourceBucket.find(SlicerHelper.makeFilter(this.mSlicer), orderBy);
        return this.checkAndDecorateFiles(sourceFiles);
    }

    @Override
    public List<IFile> find(IONObject query) throws PersistenceException {
        SlicerHelper.checkForSlicer(query, this.mSlicer);
        List<IFile> sourceFiles = this.mSourceBucket.find(SlicerHelper.withFilter(query, this.mSlicer));
        return this.checkAndDecorateFiles(sourceFiles);
    }

    @Override
    public List<IFile> find(IONObject query, IONObject orderBy) throws PersistenceException {
        SlicerHelper.checkForSlicer(query, this.mSlicer);
        List<IFile> sourceFiles = this.mSourceBucket.find(SlicerHelper.withFilter(query, this.mSlicer), orderBy);
        return this.checkAndDecorateFiles(sourceFiles);
    }

    @Override
    public IFile findOne(IONObject query) throws PersistenceException {
        SlicerHelper.checkForSlicer(query, this.mSlicer);
        IFile sourceFile = this.mSourceBucket.findOne(SlicerHelper.withFilter(query, this.mSlicer));
        return this.checkAndDecorateFile(sourceFile);
    }

    @Override
    public List<IFile> find(String filename) throws PersistenceException {
        return this.find(new QueryBuilder().equalTo("filename", filename).toDocument());
    }

    @Override
    public List<IFile> find(String filename, IONObject orderBy) throws PersistenceException {
        return this.find(new QueryBuilder().equalTo("filename", filename).toDocument(), orderBy);
    }

    @Override
    public IFile findOne(String filename) throws PersistenceException {
        return this.findOne(new QueryBuilder().equalTo("filename", filename).toDocument());
    }

    @Override
    public IFile findMostRecent(String filename) throws PersistenceException {
        IONObject sort;
        IONObject query = new QueryBuilder().equalTo("filename", filename).toDocument();
        List<IFile> files = this.find(query, sort = new SortBuilder().descending("uploadDate").toDocument());
        if (files.isEmpty()) {
            return null;
        }
        return files.get(0);
    }

    @Override
    public void remove(IONObjectId fileId) throws PersistenceException {
        this.remove(new QueryBuilder().equalTo("_id", fileId).toDocument());
    }

    @Override
    public void remove(IONObject query) throws PersistenceException {
        SlicerHelper.checkForSlicer(query, this.mSlicer);
        this.mSourceBucket.remove(SlicerHelper.withFilter(query, this.mSlicer));
    }

    @Override
    public void clear() throws PersistenceException {
        this.mSourceBucket.remove(SlicerHelper.makeFilter(this.mSlicer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop() throws PersistenceException {
        List<IDropListener> list = this.mDropListeners;
        synchronized (list) {
            for (IDropListener listener : this.mDropListeners) {
                listener.onDropped(this);
            }
        }
        this.clear();
    }

    private IFile checkAndDecorateFile(IFile sourceFile) throws PersistenceException {
        if (null == sourceFile) {
            return null;
        }
        Object actualValue = sourceFile.getValue(this.mSlicer.getKey());
        if (null == actualValue) {
            throw new PersistenceException.SliceBoundary("Encountered an IFile with a missing slicer value", this.mSlicer, null);
        }
        Object expectedValue = this.mSlicer.getValue();
        if (!actualValue.equals(expectedValue)) {
            throw new PersistenceException.SliceBoundary("Encountered an IFile with an unexpected slicer value", this.mSlicer, null);
        }
        return new SlicedFile(this, sourceFile, this.mSlicer);
    }

    private List<IFile> checkAndDecorateFiles(List<IFile> sourceFiles) throws PersistenceException {
        ArrayList<IFile> decorateFiles = new ArrayList<IFile>(sourceFiles.size());
        for (IFile sourceFile : sourceFiles) {
            decorateFiles.add(this.checkAndDecorateFile(sourceFile));
        }
        return decorateFiles;
    }

    private void rebuildGridFSIndexes() throws PersistenceException {
        if (this.mDatabase.collectionExists(this.getBucketName() + ".files")) {
            IDocumentCollection filesCol = this.mDatabase.getDocumentCollection(this.getBucketName() + ".files");
            this.augmentUniqueIndexes(filesCol);
        }
        if (this.mDatabase.collectionExists(this.getBucketName() + ".chunks")) {
            IDocumentCollection chunksCol = this.mDatabase.getDocumentCollection(this.getBucketName() + ".chunks");
            this.augmentUniqueIndexes(chunksCol);
        }
    }

    private void augmentUniqueIndexes(IDocumentCollection col) throws PersistenceException {
        for (IndexInfo idx : col.getIndexInfo()) {
            if (!idx.isUnique() || idx.getName().equals("_id_") || idx.getName().contains(this.mSlicer.getKey())) continue;
            if (idx.isHashed()) {
                col.ensureHashedIndex(idx.getKeys()[0], idx.isUnique(), idx.isSparse());
                continue;
            }
            if (idx.isTTL()) {
                col.ensureTTLIndex(idx.getKeys()[0], idx.getExpireAfterSeconds());
                continue;
            }
            col.ensureSortedIndex(idx.getKeys(), idx.getSortOrders(), idx.isUnique(), idx.isSparse());
        }
    }
}

