/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.slice;

import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ProjectionBuilder;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.query.InvalidQueryException;
import com.ibm.neo.persist.slice.ISlicer;
import com.ibm.neo.security.SubjectHelper;
import java.util.Map;
import org.apache.commons.lang.NullArgumentException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class SlicerHelper {
    private static final Integer ZERO = 0;
    private static final Integer ONE = 1;
    private static final int LAST_CONTENT_VERSION_WITH_LEGACY_INDEXES = 9;

    private SlicerHelper() {
    }

    public static QueryBuilder insertFilter(QueryBuilder builder, ISlicer slicer) throws PersistenceException.SliceBoundary {
        return builder.equalTo(slicer.getKey(), slicer.getValue());
    }

    public static void insertFilter(IONObject doc, ISlicer slicer) throws PersistenceException.SliceBoundary {
        if (doc == null) {
            throw new NullArgumentException("doc");
        }
        doc.put(slicer.getKey(), slicer.getValue());
    }

    public static void removeFilter(IONObject doc, ISlicer slicer) {
        if (doc != null) {
            doc.remove(slicer.getKey());
        }
    }

    public static IONObject withFilter(IONObject doc, ISlicer slicer) throws PersistenceException.SliceBoundary {
        IONObject copy = SlicerHelper.shallowCopy(doc);
        SlicerHelper.insertFilter(copy, slicer);
        return copy;
    }

    public static IONObject withoutFilter(IONObject doc, ISlicer slicer) {
        IONObject copy = SlicerHelper.shallowCopy(doc);
        SlicerHelper.removeFilter(copy, slicer);
        return copy;
    }

    public static IONObject makeFilter(ISlicer slicer) throws PersistenceException.SliceBoundary {
        return new QueryBuilder().equalTo(slicer.getKey(), slicer.getValue()).toDocument();
    }

    public static ProjectionBuilder insertProjection(ProjectionBuilder builder, ISlicer slicer) {
        if (SlicerHelper.shouldAddSlicerToProjection(builder.toDocument(), slicer)) {
            builder.include(slicer.getKey());
        }
        return builder;
    }

    public static IONObject insertProjection(IONObject projection, ISlicer slicer) {
        if (SlicerHelper.shouldAddSlicerToProjection(projection, slicer)) {
            projection.put(slicer.getKey(), 1);
        }
        return projection;
    }

    public static IONObject withProjection(IONObject projection, ISlicer slicer) {
        if (SlicerHelper.shouldAddSlicerToProjection(projection, slicer)) {
            IONObject copy = SlicerHelper.shallowCopy(projection);
            copy.put(slicer.getKey(), 1);
            return copy;
        }
        return projection;
    }

    private static boolean shouldAddSlicerToProjection(IONObject projection, ISlicer slicer) {
        if (projection == null) {
            return false;
        }
        Boolean keepMode = null;
        for (String field : projection.keySet()) {
            Object value;
            if (field.equals("_id") || field.endsWith(".$") || (value = projection.get(field)) instanceof IONObject) continue;
            Number projValue = null;
            try {
                projValue = projection.getNumber(field);
            }
            catch (ClassCastException e) {
                throw new InvalidQueryException.InvalidProjectionClause(projection, "Projection clause '" + field + "' is not a number.");
            }
            if (projValue == null) {
                throw new InvalidQueryException.InvalidProjectionClause(projection, "Projection clause '" + field + "' is null.");
            }
            if (ZERO.equals(projValue)) {
                if (field.equals(slicer.getKey())) {
                    throw new InvalidQueryException.InvalidProjectionClause(projection, "The slicer key '" + slicer.getKey() + "' cannot be set to excluded in a projection clause.");
                }
                if (Boolean.TRUE.equals(keepMode)) {
                    throw new InvalidQueryException.InvalidProjectionClause(projection, "Inclusion and exclusion semantics may not be combined in one projection clause.");
                }
                keepMode = false;
                continue;
            }
            if (Boolean.FALSE.equals(keepMode)) {
                throw new InvalidQueryException.InvalidProjectionClause(projection, "Inclusion and exclusion semantics may not be combined in one projection clause.");
            }
            keepMode = true;
        }
        if (null == keepMode && ONE.equals(projection.get("_id"))) {
            return true;
        }
        return Boolean.TRUE.equals(keepMode);
    }

    public static void checkForSlicer(UpdateBuilder builder, ISlicer slicer) throws PersistenceException.SliceBoundary {
        SlicerHelper.checkForSlicer(builder.toDocument(), slicer);
    }

    public static void checkForSlicer(IONObject doc, ISlicer slicer) throws PersistenceException.SliceBoundary {
        if (doc == null) {
            return;
        }
        SlicerHelper.checkKeysForSlicer(doc, slicer);
    }

    private static void checkKeysForSlicer(IONObject doc, ISlicer slicer) throws PersistenceException.SliceBoundary {
        for (Map.Entry entry : doc.entrySet()) {
            if (((String)entry.getKey()).equals(slicer.getKey())) {
                throw new PersistenceException.SliceBoundary("Query and update clauses must not reference the slice key '" + slicer.getKey() + "':" + doc.toString());
            }
            if (!(entry.getValue() instanceof IONObject)) continue;
            SlicerHelper.checkKeysForSlicer((IONObject)entry.getValue(), slicer);
        }
    }

    public static void checkForSlicer(ISlicer slicer, IONObject ... docs) throws PersistenceException.SliceBoundary {
        for (IONObject doc : docs) {
            SlicerHelper.checkForSlicer(doc, slicer);
        }
    }

    public static IONObject insertUpdate(IONObject update, boolean upsert, ISlicer slicer) throws PersistenceException.SliceBoundary {
        if (!SlicerHelper.containsUpdateOperator(update)) {
            return SlicerHelper.withFilter(update, slicer);
        }
        if (upsert) {
            return new UpdateBuilder().putAll(update).set(slicer.getKey(), slicer.getValue()).toDocument();
        }
        return update;
    }

    private static boolean containsUpdateOperator(IONObject update) {
        for (String key : update.keySet()) {
            if (!key.startsWith("$")) continue;
            return true;
        }
        return false;
    }

    public static IONObject validateAndRemoveSlicer(IONObject ion, ISlicer slicer) throws PersistenceException.SliceBoundary {
        if (ion == null) {
            return null;
        }
        if (!ion.containsKey(slicer.getKey())) {
            throw new PersistenceException.SliceBoundary("SlicedCursor encountered a document with no slicer field.", slicer, ion);
        }
        if (!slicer.getValue().equals(ion.get(slicer.getKey()))) {
            throw new PersistenceException.SliceBoundary("SlicedCursor encountered a document with an unexpected slice value.", slicer, ion);
        }
        SlicerHelper.removeFilter(ion, slicer);
        return ion;
    }

    public static boolean useLegacyIndexes() {
        Integer contentVersion = (Integer)SubjectHelper.getSessionAttribute((Subject)SecurityUtils.getSubject(), (String)"tenant.content.version", Integer.class, (boolean)false);
        return null == contentVersion || contentVersion <= 9;
    }

    private static IONObject shallowCopy(IONObject doc) {
        if (doc == null) {
            return new IONObject();
        }
        return new IONObject(doc);
    }
}

