/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.update;

import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.update.ArrayUpdateOperator;
import com.ibm.neo.persist.update.UpdateParser;
import java.util.HashSet;

public class AddToSetOperator
extends ArrayUpdateOperator {
    private boolean addValueAsSingle;

    public AddToSetOperator(String field, Object value) {
        this(field, new IONArray(value), false);
    }

    public AddToSetOperator(String field, IONArray values, boolean addAsSingleElement) {
        super(field, values);
        this.addValueAsSingle = addAsSingleElement;
    }

    @Override
    protected String getOperatorName() {
        return UpdateParser.Operator.$addToSet.name();
    }

    @Override
    protected boolean updateArrayField(IONArray array, IONObject parentObj) {
        IONArray entriesToAdd;
        if (array == null) {
            array = new IONArray();
            parentObj.put(this.getSelector().getTailingCrumb(), array);
        }
        IONArray originalCopy = array.duplicate();
        HashSet<Object> set = new HashSet<Object>(array);
        if (this.addValueAsSingle) {
            entriesToAdd = new IONArray();
            entriesToAdd.add(this.mValues);
        } else {
            entriesToAdd = this.mValues;
        }
        for (Object entryToAdd : entriesToAdd) {
            if (!set.add(entryToAdd)) continue;
            array.add(entryToAdd);
        }
        return !originalCopy.equals(array);
    }
}

