/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.update;

import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONArtifact;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.update.FieldOperator;
import com.ibm.neo.persist.update.InvalidUpdateException;

public abstract class ArrayUpdateOperator
extends FieldOperator {
    protected final IONArray mValues;

    public ArrayUpdateOperator(String field, IONArray values) {
        super(field);
        this.mValues = values;
    }

    @Override
    public boolean update(IONObject object) {
        if (this.mValues == null && this.mValues.isEmpty()) {
            return false;
        }
        IONArtifact container = this.getSelector().getFieldContainer(object, true);
        if (container instanceof IONObject) {
            IONArray array;
            IONObject parentObj = (IONObject)container;
            try {
                array = parentObj.getIONArray(this.getSelector().getTailingCrumb());
            }
            catch (ClassCastException e) {
                throw new InvalidUpdateException.UpdateNotApplicable(object, "Cannot " + this.getOperatorName() + " on " + this.getSelector().getTailingCrumb() + ", as it is not an array.");
            }
            return this.updateArrayField(array, parentObj);
        }
        return false;
    }

    protected abstract String getOperatorName();

    protected abstract boolean updateArrayField(IONArray var1, IONObject var2);
}

