/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.update;

import com.ibm.neo.persist.ion.IONObject;

public class InvalidUpdateException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public InvalidUpdateException() {
    }

    public InvalidUpdateException(String message) {
        super(message);
    }

    private static String safeIONObjectToString(IONObject ion) {
        try {
            return ion.toString();
        }
        catch (Exception e) {
            return "<unprintable IONObject>";
        }
    }

    public static class UpdateNotApplicable
    extends InvalidUpdateException {
        private static final long serialVersionUID = 1L;

        public UpdateNotApplicable(IONObject object, String reason) {
            super("Update is not applicable for document " + InvalidUpdateException.safeIONObjectToString(object) + ": " + reason);
        }
    }

    public static class UpdateAndReplaceOperators
    extends InvalidUpdateException {
        private static final long serialVersionUID = 1L;

        public UpdateAndReplaceOperators(IONObject update) {
            super("Update " + update.toString() + " cannot contain both update operators and replacement fields.");
        }
    }

    public static class UnsupportedOperator
    extends InvalidUpdateException {
        private static final long serialVersionUID = 1L;

        public UnsupportedOperator(String operator) {
            super("The update operator " + operator + " is not supported.");
        }
    }
}

