/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.update;

import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.update.ArrayUpdateOperator;
import com.ibm.neo.persist.update.UpdateParser;
import java.util.Collection;

public class PushOperator
extends ArrayUpdateOperator {
    private final Integer mSlice;

    public PushOperator(String field, Object value) {
        this(field, new IONArray(value), null);
    }

    public PushOperator(String field, IONArray values, Integer slice) {
        super(field, values);
        this.mSlice = slice;
    }

    @Override
    protected boolean updateArrayField(IONArray array, IONObject parentObj) {
        if (array == null) {
            array = new IONArray();
            parentObj.put(this.getSelector().getTailingCrumb(), array);
        }
        IONArray copyOfOriginal = array.duplicate();
        array.addAll(this.mValues);
        if (this.mSlice != null) {
            int arraySize = array.size();
            if (this.mSlice < 0) {
                if (arraySize + this.mSlice > 0) {
                    IONArray updatedArray = new IONArray((Collection<?>)array.subList(arraySize + this.mSlice, arraySize));
                    array.clear();
                    array.addAll(updatedArray);
                }
            } else if (this.mSlice < arraySize) {
                IONArray updatedArray = new IONArray((Collection<?>)array.subList(0, this.mSlice));
                array.clear();
                array.addAll(updatedArray);
            }
        }
        return !copyOfOriginal.equals(array);
    }

    @Override
    protected String getOperatorName() {
        return UpdateParser.Operator.$push.name();
    }
}

