/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.persist.update;

import com.ibm.neo.persist.ion.IONArray;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.update.AddToSetOperator;
import com.ibm.neo.persist.update.IncOperator;
import com.ibm.neo.persist.update.InvalidUpdateException;
import com.ibm.neo.persist.update.PullOperator;
import com.ibm.neo.persist.update.PushOperator;
import com.ibm.neo.persist.update.ReplaceOperator;
import com.ibm.neo.persist.update.SetOperator;
import com.ibm.neo.persist.update.UnsetOperator;
import com.ibm.neo.persist.update.UpdateOperator;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class UpdateParser {
    private static final EnumSet<Operator> sUnsupportedModifiers = EnumSet.of(Operator.$sort, Operator.$position);

    public static List<UpdateOperator> parseUpdate(IONObject update) throws InvalidUpdateException {
        LinkedList<UpdateOperator> operators = new LinkedList<UpdateOperator>();
        if (update == null || update.isEmpty()) {
            return operators;
        }
        Boolean hasUpdateOperators = null;
        for (String field : update.keySet()) {
            try {
                Operator op = Operator.valueOf(field);
                if (hasUpdateOperators != null && !hasUpdateOperators.booleanValue()) {
                    throw new InvalidUpdateException.UpdateAndReplaceOperators(update);
                }
                hasUpdateOperators = true;
                operators.addAll(UpdateParser.parseUpdateOperator(op, update.get(field)));
            }
            catch (IllegalArgumentException e) {
                if (hasUpdateOperators != null && hasUpdateOperators.booleanValue()) {
                    throw new InvalidUpdateException.UpdateAndReplaceOperators(update);
                }
                hasUpdateOperators = false;
            }
        }
        if (!hasUpdateOperators.booleanValue()) {
            operators.add(new ReplaceOperator(update));
        }
        return operators;
    }

    private static List<UpdateOperator> parseUpdateOperator(Operator op, Object value) {
        LinkedList<UpdateOperator> operators = new LinkedList<UpdateOperator>();
        try {
            IONObject opParam = (IONObject)value;
            switch (op) {
                case $inc: {
                    for (Map.Entry entry : opParam.entrySet()) {
                        if (entry.getValue() instanceof Number) {
                            operators.add(new IncOperator((String)entry.getKey(), (Number)entry.getValue()));
                            continue;
                        }
                        throw new InvalidUpdateException("Operator " + op.name() + " expects a numeric parameter.");
                    }
                    break;
                }
                case $set: {
                    for (Map.Entry entry : opParam.entrySet()) {
                        operators.add(new SetOperator((String)entry.getKey(), entry.getValue()));
                    }
                    break;
                }
                case $unset: {
                    for (String key : opParam.keySet()) {
                        operators.add(new UnsetOperator(key));
                    }
                    break;
                }
                case $push: {
                    for (Map.Entry entry : opParam.entrySet()) {
                        String field = (String)entry.getKey();
                        if (entry.getValue() instanceof IONObject) {
                            IONObject fieldValue = (IONObject)entry.getValue();
                            UpdateParser.checkForUnsupportedModifiers(fieldValue);
                            IONArray each = UpdateParser.parseEach(fieldValue);
                            if (each == null) {
                                operators.add(new PushOperator(field, fieldValue));
                                continue;
                            }
                            Integer slice = UpdateParser.parseSlice(fieldValue);
                            operators.add(new PushOperator(field, each, slice));
                            continue;
                        }
                        operators.add(new PushOperator(field, entry.getValue()));
                    }
                    break;
                }
                case $pull: {
                    for (Map.Entry entry : opParam.entrySet()) {
                        String field = (String)entry.getKey();
                        if (entry.getValue() instanceof IONArray) {
                            operators.add(new PullOperator(field, (IONArray)entry.getValue()));
                            continue;
                        }
                        operators.add(new PullOperator(field, new IONArray(entry.getValue())));
                    }
                    break;
                }
                case $addToSet: {
                    for (Map.Entry entry : opParam.entrySet()) {
                        String field = (String)entry.getKey();
                        if (entry.getValue() instanceof IONObject) {
                            IONObject fieldValue = (IONObject)entry.getValue();
                            UpdateParser.checkForUnsupportedModifiers(fieldValue);
                            IONArray each = UpdateParser.parseEach(fieldValue);
                            if (each == null) {
                                operators.add(new AddToSetOperator(field, fieldValue));
                                continue;
                            }
                            operators.add(new AddToSetOperator(field, each, false));
                            continue;
                        }
                        if (entry.getValue() instanceof IONArray) {
                            operators.add(new AddToSetOperator(field, (IONArray)entry.getValue(), false));
                            continue;
                        }
                        operators.add(new AddToSetOperator(field, entry.getValue()));
                    }
                    break;
                }
                default: {
                    throw new InvalidUpdateException("Operator " + op.name() + " is not currently supported.");
                }
            }
        }
        catch (ClassCastException e) {
            throw new InvalidUpdateException("Operator " + op.name() + " has an unexpected operand type.");
        }
        return operators;
    }

    private static IONArray parseEach(IONObject fieldValue) throws InvalidUpdateException {
        if (fieldValue.containsKey(Operator.$each.name())) {
            try {
                return fieldValue.getIONArray(Operator.$each.name());
            }
            catch (ClassCastException e) {
                throw new InvalidUpdateException("The value for operator $each is expected to be an array.");
            }
        }
        return null;
    }

    private static Integer parseSlice(IONObject fieldValue) {
        if (fieldValue.containsKey(Operator.$slice.name())) {
            try {
                return (Integer)fieldValue.getNumber(Operator.$slice.name());
            }
            catch (ClassCastException e) {
                throw new InvalidUpdateException("The value for operator $slice is expected to be an integer.");
            }
        }
        return null;
    }

    private static void checkForUnsupportedModifiers(Object clause) {
        if (clause instanceof IONObject) {
            IONObject clauseObj = (IONObject)clause;
            for (String key : clauseObj.keySet()) {
                try {
                    if (!sUnsupportedModifiers.contains((Object)Operator.valueOf(key))) continue;
                    throw new InvalidUpdateException.UnsupportedOperator(key);
                }
                catch (IllegalArgumentException e) {
                }
            }
        }
    }

    static enum Operator {
        $inc,
        $mul,
        $rename,
        $setOnInsert,
        $set,
        $unset,
        $min,
        $max,
        $currentDate,
        $,
        $addToSet,
        $pop,
        $pull,
        $pushAll,
        $push,
        $each,
        $slice,
        $sort,
        $position,
        $bit;

    }
}

