/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.jdbc41.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.BaseDatabaseMetadataAdaptor;
import com.ibm.cognos.jdbc.adaptor.BaseResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class BigqueryDatabaseMetadataAdaptor
extends BaseDatabaseMetadataAdaptor {
    public BigqueryDatabaseMetadataAdaptor(Object obj, AdaptorFactory factory) {
        super((DatabaseMetaData)obj, factory);
    }

    public ResultSet getCatalogsImpl() throws SQLException {
        ResultSet rs = this.dmd.getSchemas();
        return new BigqueryCatalogsResultSetAdaptor(rs, this.factory);
    }

    public ResultSet getColumnsImpl(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Object rs = this.dmd.getColumns(catalog, schemaPattern, tableNamePattern, columnNamePattern);
        rs = new BigqueryColumnsResultSetAdaptor((ResultSet)rs, this.factory);
        return rs;
    }

    public static class BigqueryCatalogsResultSetAdaptor
    extends BaseResultSetAdaptor {
        ArrayList<String> catalog = new ArrayList();
        Iterator<String> itr = null;

        BigqueryCatalogsResultSetAdaptor(ResultSet rs, AdaptorFactory f) {
            super(rs, f);
            try {
                while (rs.next()) {
                    this.catalog.add(rs.getString("TABLE_CATALOG"));
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            Collections.sort(this.catalog);
            this.catalog = new ArrayList<String>(new LinkedHashSet<String>(this.catalog));
        }

        public String getString(int colNo) throws SQLException {
            return this.itr.next();
        }

        public boolean next() {
            if (this.itr == null) {
                this.itr = this.catalog.iterator();
            }
            return this.itr.hasNext();
        }
    }

    public static class BigqueryColumnsResultSetAdaptor
    extends BaseResultSetAdaptor {
        private static final int DECIMAL_DIGITS = 9;

        BigqueryColumnsResultSetAdaptor(ResultSet rs, AdaptorFactory f) {
            super(rs, f);
        }

        public int getInt(int colNo) throws SQLException {
            if (colNo == 9) {
                try {
                    return this.rs.getInt(colNo);
                }
                catch (SQLDataException e) {
                    return 0;
                }
            }
            return this.rs.getInt(colNo);
        }
    }

    public static final class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new BigqueryDatabaseMetadataAdaptor((DatabaseMetaData)toWrap, factory);
        }
    }
}

