/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.org.apache.hadoop.io;

import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.parquet.bytes.BytesInput;

public class ParquetOutputStream
extends OutputStream {
    private OutputStream os;
    private boolean encrypt;

    public ParquetOutputStream(OutputStream outputStream, boolean encryptionEnabled) {
        this.os = outputStream;
        this.encrypt = encryptionEnabled;
    }

    @Override
    public void write(byte[] b, int offset, int length) throws IOException {
        this.os.write(b, offset, length);
    }

    @Override
    public void write(int b) throws IOException {
        this.os.write(b);
    }

    @Override
    public void flush() throws IOException {
        this.os.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            ByteArrayOutputStream baos = (ByteArrayOutputStream)this.os;
            byte[] data = BytesInput.from((ByteArrayOutputStream)baos).toByteArray();
            baos.reset();
            if (this.encrypt) {
                baos.write(new byte[]{1});
                baos.write(CryptoProvider.encrypt(data));
            } else {
                baos.write(new byte[]{0});
                baos.write(data);
            }
            this.os.close();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

