/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tunnel;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ibm.bi.crypto.tunnel.TunnelException;
import com.ibm.bi.crypto.tunnel.TunnelSession;
import com.ibm.bi.crypto.tunnel.TunnelSessionEventsListener;
import com.ibm.bi.crypto.tunnel.TunnelSessionStatus;
import com.ibm.bi.crypto.tunnel.tcp.TcpTunnelSession;
import com.ibm.bi.crypto.tunnel.tcp.TcpTunnelSessionParams;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Tunnels {
    public static final int TUNNELS_CLEANING_PERIOD = 500;
    private static final ExecutorService CLEANER_EXECUTOR_SERVICE = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("TUNNELS CLEANER-%d").setDaemon(true).build());
    private static final Logger LOG = LoggerFactory.getLogger(Tunnels.class);
    private static final Map<TcpTunnelSessionParams, TunnelSessionCacheEntry<TcpTunnelSession>> TCP_TUNNEL_SESSIONS = new ConcurrentHashMap<TcpTunnelSessionParams, TunnelSessionCacheEntry<TcpTunnelSession>>();

    public static TunnelSession tcpTunnelSession(TcpTunnelSessionParams sessionParams) {
        LOG.info("THREAD {}: RETRIEVING TCP TUNNEL SESSION FOR PARAMS {}", (Object)Thread.currentThread().getName(), (Object)sessionParams);
        TunnelSessionCacheEntry sessionCacheEntry = TCP_TUNNEL_SESSIONS.compute(sessionParams, (params, tunnelSessionCacheEntry) -> {
            if (tunnelSessionCacheEntry == null) {
                return Tunnels.newTcpTunnelSession(sessionParams);
            }
            if (((TcpTunnelSession)tunnelSessionCacheEntry.tunnelSession()).isClosed()) {
                return Tunnels.newTcpTunnelSession(sessionParams);
            }
            ((TunnelSessionCacheEntry)tunnelSessionCacheEntry).markActive();
            return tunnelSessionCacheEntry;
        });
        return new CachedTunnelSession((TunnelSession)sessionCacheEntry.borrowTunnelSession(), sessionCacheEntry.refCount);
    }

    private static TunnelSessionCacheEntry<TcpTunnelSession> newTcpTunnelSession(TcpTunnelSessionParams sessionParams) {
        LOG.info("THREAD {}: CREATING A NEW TCP TUNNEL SESSION FOR PARAMS {}", (Object)Thread.currentThread().getName(), (Object)sessionParams);
        TunnelSessionCacheEntry<TcpTunnelSession> sessionCacheEntry = new TunnelSessionCacheEntry<TcpTunnelSession>();
        ((TunnelSessionCacheEntry)sessionCacheEntry).maxInactivityPeriod = sessionParams.maxInactivityPeriod();
        ((TunnelSessionCacheEntry)sessionCacheEntry).tunnelSession = new TcpTunnelSession(sessionParams, sessionCacheEntry);
        return sessionCacheEntry;
    }

    static {
        CLEANER_EXECUTOR_SERVICE.submit(() -> {
            try {
                block2: while (true) {
                    Thread.sleep(500L);
                    Iterator<TcpTunnelSessionParams> iterator = TCP_TUNNEL_SESSIONS.keySet().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block2;
                        TcpTunnelSessionParams sessionParams = iterator.next();
                        TCP_TUNNEL_SESSIONS.compute(sessionParams, (sessionParams1, tunnelSessionCacheEntry) -> {
                            if (((TcpTunnelSession)tunnelSessionCacheEntry.tunnelSession()).isClosed()) {
                                LOG.info("THREAD {} at {}: EVACUATING CLOSED SESSION {} FROM TCP TUNNEL SESSIONS CACHE", new Object[]{Thread.currentThread().getName(), LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME), tunnelSessionCacheEntry.tunnelSession()});
                                return null;
                            }
                            if (tunnelSessionCacheEntry.hasBeenInactiveForMaxInactivityPeriod()) {
                                LOG.info("THREAD {} at {}: CLOSING AND EVACUATING INACTIVE SESSION {} FROM TCP TUNNEL SESSIONS CACHE", new Object[]{Thread.currentThread().getName(), LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME), tunnelSessionCacheEntry.tunnelSession()});
                                try {
                                    ((TcpTunnelSession)tunnelSessionCacheEntry.tunnelSession()).close();
                                }
                                catch (TunnelException e) {
                                    LOG.error("THREAD {} at {}: COULD NOT CLOSE TCP TUNNEL SESSION {}", new Object[]{Thread.currentThread().getName(), LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME), tunnelSessionCacheEntry.tunnelSession()});
                                }
                                finally {
                                    return null;
                                }
                            }
                            return tunnelSessionCacheEntry;
                        });
                    }
                    break;
                }
            }
            catch (Exception e) {
                LOG.error("THREAD {}: TCP TUNNEL SESSIONS CLEANER ERROR ", (Object)Thread.currentThread().getName(), (Object)e);
                return;
            }
        });
    }

    private static class TunnelSessionCacheEntry<T extends TunnelSession>
    implements TunnelSessionEventsListener {
        private final Object activityLock = new Object();
        private final AtomicInteger refCount = new AtomicInteger();
        private T tunnelSession;
        private long maxInactivityPeriod;
        private volatile long lastInactivityTime = -1L;

        private TunnelSessionCacheEntry() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markActive() {
            Object object = this.activityLock;
            synchronized (object) {
                LOG.info("THREAD {} at {}: MARK ACTIVE TCP TUNNEL SESSION {}", new Object[]{Thread.currentThread().getName(), LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME), this.tunnelSession});
                this.lastInactivityTime = -1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void markInactive() {
            Object object = this.activityLock;
            synchronized (object) {
                LOG.info("THREAD {} at {}: MARK INACTIVE TCP TUNNEL SESSION {}", new Object[]{Thread.currentThread().getName(), LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME), this.tunnelSession});
                this.lastInactivityTime = System.currentTimeMillis();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isActive() {
            Object object = this.activityLock;
            synchronized (object) {
                return this.lastInactivityTime == -1L;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean hasBeenInactiveForMaxInactivityPeriod() {
            Object object = this.activityLock;
            synchronized (object) {
                if (!this.isActive()) {
                    return System.currentTimeMillis() - this.lastInactivityTime >= this.maxInactivityPeriod;
                }
                return false;
            }
        }

        public T tunnelSession() {
            return this.tunnelSession;
        }

        public T borrowTunnelSession() {
            this.refCount.incrementAndGet();
            return this.tunnelSession;
        }

        @Override
        public void onSessionClose(TunnelSession closedTunnelSession) {
        }

        @Override
        public void onSessionActivate(TunnelSession activatedTunnelSession) {
            this.markActive();
        }

        @Override
        public void onSessionDeactivate(TunnelSession deactivatedTunnelSession) {
            this.markInactive();
        }
    }

    static class CachedTunnelSession
    implements TunnelSession {
        private static final Logger LOGGER = LoggerFactory.getLogger(CachedTunnelSession.class);
        final TunnelSession tunnelSession;
        private final AtomicInteger refCounter;

        public CachedTunnelSession(TunnelSession tunnelSession, AtomicInteger refCount) throws TunnelException {
            this.tunnelSession = tunnelSession;
            this.refCounter = refCount;
        }

        @Override
        public void close() throws Exception {
            if (this.refCounter.decrementAndGet() == 0) {
                LOGGER.info("Thread {} is closing cached session {}", (Object)Thread.currentThread().getName(), (Object)this.tunnelSession);
                this.tunnelSession.close();
            } else {
                LOGGER.info("Thread {} could not close cached session {} because it is still referenced by {} referees", new Object[]{Thread.currentThread().getName(), this.tunnelSession, this.refCounter.get()});
            }
        }

        @Override
        public String localHostname() {
            return this.tunnelSession.localHostname();
        }

        @Override
        public int localPort() {
            return this.tunnelSession.localPort();
        }

        @Override
        public boolean isActive() {
            return this.tunnelSession.isActive();
        }

        @Override
        public boolean isClosed() {
            return this.tunnelSession.isClosed();
        }

        @Override
        public TunnelSessionStatus status() {
            return this.tunnelSession.status();
        }
    }
}

