/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tunnel.tcp;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ibm.bi.crypto.tunnel.TunnelException;
import com.ibm.bi.crypto.tunnel.TunnelSession;
import com.ibm.bi.crypto.tunnel.TunnelSessionEventsListener;
import com.ibm.bi.crypto.tunnel.TunnelSessionParams;
import com.ibm.bi.crypto.tunnel.TunnelSessionStatus;
import com.ibm.bi.crypto.tunnel.tcp.SocketsFactory;
import com.ibm.bi.crypto.tunnel.tcp.TcpTunnelConnection;
import com.ibm.bi.crypto.tunnel.tcp.TcpTunnelConnectionEventsListener;
import com.ibm.bi.crypto.tunnel.tcp.TcpTunnelSessionParams;
import com.ibm.bi.crypto.tunnel.tcp.TcpTunnelSessionStatus;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpTunnelSession
implements TunnelSession,
TcpTunnelConnectionEventsListener,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(TcpTunnelSession.class);
    private final Object closeLock;
    private Set<TcpTunnelConnection> connections;
    private ServerSocket localServer;
    private TunnelSessionParams sessionParams;
    private ExecutorService executorService;
    private boolean isClosed;
    private TunnelSessionEventsListener tunnelSessionEventsListener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TcpTunnelSession(TcpTunnelSessionParams sessionParams, TunnelSessionEventsListener tunnelSessionEventsListener) throws TunnelException {
        block11: {
            this.closeLock = new Object();
            this.connections = new ConcurrentHashMap().keySet(Boolean.TRUE);
            Objects.requireNonNull(sessionParams, "TCP tunnel session params should not be null");
            IOException startUpException = null;
            try {
                this.sessionParams = sessionParams;
                this.tunnelSessionEventsListener = tunnelSessionEventsListener;
                this.localServer = new ServerSocket(0);
                this.executorService = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("TTS(localhost:" + this.localServer.getLocalPort() + ")-%d").build());
                this.executorService.submit(this);
            }
            catch (IOException e) {
                startUpException = e;
                return startUpException;
            }
            finally {
                if (startUpException == null) break block11;
                try {
                    this.close();
                }
                catch (Exception e) {
                    throw new TunnelException("could not clean up tcp tunnel session after startup failure", e);
                }
                throw new TunnelException("could not create TcpTunnelSession", startUpException);
            }
        }
    }

    @Override
    public String localHostname() {
        return this.localServer.getInetAddress().getHostName();
    }

    @Override
    public int localPort() {
        return this.localServer.getLocalPort();
    }

    @Override
    public boolean isActive() {
        return !this.connections.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClosed() {
        Object object = this.closeLock;
        synchronized (object) {
            return this.isClosed;
        }
    }

    @Override
    public TunnelSessionStatus status() {
        return new TcpTunnelSessionStatus(this.connections);
    }

    @Override
    public void close() throws TunnelException {
        LOG.info("THREAD {}: Closing TCP tunnel session {} by {}", new Object[]{Thread.currentThread().getName(), this, Thread.currentThread().getStackTrace()});
        this.doCloseSession();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCloseSession() {
        Object object = this.closeLock;
        synchronized (object) {
            try {
                this.connections.forEach(connection -> connection.terminateConnection());
                if (this.localServer != null) {
                    this.localServer.close();
                }
                if (this.executorService != null) {
                    this.executorService.shutdownNow();
                }
                this.isClosed = true;
                this.tunnelSessionEventsListener.onSessionClose(this);
            }
            catch (Exception e) {
                LOG.error("THREAD {}: could not close TCP tunnel session {}, because of {}", new Object[]{Thread.currentThread().getName(), this, e});
                throw new TunnelException("could not close session", e);
            }
        }
    }

    @Override
    public void run() {
        try {
            try {
                while (true) {
                    Socket localSocket = this.localServer.accept();
                    LOG.info("THREAD {}: TcpTunnelSession {} accepted a new connection from {}:{}", new Object[]{Thread.currentThread().getName(), this, localSocket.getInetAddress(), localSocket.getPort()});
                    Socket remoteSocket = null;
                    this.tunnelSessionEventsListener.onSessionActivate(this);
                    int maxRetry = 4;
                    for (int i = 0; i < 4; ++i) {
                        try {
                            LOG.info("Thread {}: Trying to connect to remote destination {}", (Object)Thread.currentThread().getName(), (Object)this.sessionParams);
                            if (this.sessionParams.enableMutualAuth()) {
                                remoteSocket = SocketsFactory.sslSocket(this.sessionParams.remoteHostname(), this.sessionParams.remotePort(), this.sessionParams.tlsCredentials().key(), this.sessionParams.tlsCredentials().certificateChain(), this.sessionParams.tlsCredentials().trustedCertificates());
                                break;
                            }
                            remoteSocket = SocketsFactory.sslSocket(this.sessionParams.remoteHostname(), this.sessionParams.remotePort(), this.sessionParams.tlsCredentials().trustedCertificates());
                            break;
                        }
                        catch (Exception e) {
                            LOG.info("Exception caught during try number {} ran by thread {}. {}", new Object[]{i, Thread.currentThread().getName(), e});
                            if (i != 3) continue;
                            throw e;
                        }
                    }
                    this.connections.add(new TcpTunnelConnection(localSocket, remoteSocket, this, this.executorService));
                }
            }
            catch (Exception e) {
                LOG.info("THREAD {}: TcpTunnelSession {} is no longer accepting connections {}", new Object[]{Thread.currentThread().getName(), this, e});
                throw new TunnelException("problem while accepting connections ", e);
            }
        }
        catch (Throwable throwable) {
            LOG.info("THREAD {}: Cleaning TcpTunnelSession {}", (Object)Thread.currentThread().getName(), (Object)this);
            this.doCloseSession();
            throw throwable;
        }
    }

    @Override
    public void onConnectionClose(TcpTunnelConnection tcpTunnelConnection) {
        if (this.connections.contains(tcpTunnelConnection)) {
            LOG.info("THREAD {}: CLEANING CLOSED CONNECTION {} FROM TUNNEL SESSION {}", new Object[]{Thread.currentThread().getName(), tcpTunnelConnection, this});
            this.connections.remove(tcpTunnelConnection);
        }
        if (this.connections.isEmpty()) {
            this.tunnelSessionEventsListener.onSessionDeactivate(this);
        }
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("localUrl", (Object)(this.localHostname() + ":" + this.localPort())).append("sessionParams", (Object)this.sessionParams).append("connections", this.connections).toString();
    }
}

