/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient;

import com.ibm.wa.webclient.IHeaderProvider;
import com.ibm.wa.webclient.WAApplicationClientException;
import com.ibm.wa.webclient.util.PoolingHttpClientBuilder;
import com.ibm.wa.webclient.util.RestClientBuilder;
import com.ibm.wa.webclient.util.RuleBasedRetryStrategy;
import com.ibm.wa.webclient.util.UriResolver;
import com.ibm.wa.webclient.util.WatsonHeaders;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.AutoRetryHttpClient;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;
import org.apache.wink.client.handlers.ClientHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAApplicationClient {
    protected static final transient Logger LOG = LoggerFactory.getLogger(WAApplicationClient.class);
    private static final String PROP_CONNECT_TIMEOUT = "appclient.connect-timeout";
    private static final int DEFAULT_CONNECT_TIMEOUT_MS = 10000;
    private static final String PROP_CONNECTION_TOTAL = "appclient.connection-total";
    private static final int DEFAULT_CONNECTION_TOTAL = 50;
    private static final String PROP_CONNECTION_ROUTE_TOTAL = "appclient.connection-route-total";
    private static final int DEFAULT_CONNECTION_ROUTE_TOTAL = 50;
    private static final String PROP_CONNECTION_TTL = "appclient.connection-ttl";
    private static final int DEFAULT_CONNECTION_TTL_MS = 300000;
    private static final String PROP_SERVER_ERROR_RETRY_DELAY = "appclient.server-error-retry-delay";
    private static final int DEFAULT_SERVER_ERROR_RETRY_DELAY_MS = 2000;
    private static final String PROP_BYPASS_HOSTNAME_VERIFICATION = "appclient.bypass-hostname-verification";
    private static final boolean DEFAULT_BYPASS_HOSTNAME_VERIFICATION = false;
    private static final String PROP_TRUST_ALL_CERTIFICATES = "appclient.trust-all-certificates";
    private static final boolean DEFAULT_TRUST_ALL_CERTIFICATES = false;
    private HttpClient mHttpClient;
    private RestClient mRestClient;
    private final String mName;
    private final String mAppRoot;
    private final IHeaderProvider mHeaderProvider;
    private GatewayMode mGatewayMode = GatewayMode.plaintext;

    protected WAApplicationClient() {
        this("CDI_dummy_client", "CDI_dummy_client_root", new IHeaderProvider(){

            @Override
            public Map<String, List<String>> getHttpHeaders() throws WAApplicationClientException {
                return null;
            }
        });
    }

    public WAApplicationClient(String name, String applicationRoot, IHeaderProvider headerProvider) {
        this(name, applicationRoot, headerProvider, GatewayMode.plaintext);
    }

    public WAApplicationClient(String name, String applicationRoot, IHeaderProvider headerProvider, GatewayMode mode) {
        this.mName = name;
        this.mAppRoot = applicationRoot;
        this.mHeaderProvider = headerProvider;
        this.mGatewayMode = mode;
    }

    @Deprecated
    public void initialize(Properties config) {
        this.initialize(config, new ClientHandler[0]);
    }

    public void initialize(Properties config, ClientHandler ... handlers) {
        PoolingHttpClientBuilder builder = new PoolingHttpClientBuilder();
        builder.withConnectionTotal(this.getIntParameter(config, PROP_CONNECTION_TOTAL, 50));
        builder.withConnectionRouteTotal(this.getIntParameter(config, PROP_CONNECTION_ROUTE_TOTAL, 50));
        builder.withConnectionTTL(this.getIntParameter(config, PROP_CONNECTION_TTL, 300000));
        builder.withConnectTimeout(this.getIntParameter(config, PROP_CONNECT_TIMEOUT, 10000));
        if (this.getBooleanParameter(config, PROP_TRUST_ALL_CERTIFICATES, false)) {
            builder.withSchemePortTLSProtocols("https", 443, "SSLv3", "TLSv1.2");
        }
        HttpClient poolingClient = builder.build();
        RuleBasedRetryStrategy retryStrategy = new RuleBasedRetryStrategy(this.getIntParameter(config, PROP_SERVER_ERROR_RETRY_DELAY, 2000)).addRule(500, 2).addRule(502, 2).addRule(503, 5).addRule(504, 5);
        this.mHttpClient = new AutoRetryHttpClient(poolingClient, (ServiceUnavailableRetryStrategy)retryStrategy);
        this.mRestClient = new RestClientBuilder().withBypassHostnameVerification(this.getBooleanParameter(config, PROP_BYPASS_HOSTNAME_VERIFICATION, false)).withFollowRedirects(false).withHandlers(handlers).withHttpClient(this.mHttpClient).build();
    }

    private int getIntParameter(Properties config, String parameter, int defaultValue) {
        String param = config.getProperty(this.mName + "." + parameter);
        if (param == null) {
            param = config.getProperty(parameter, Integer.toString(defaultValue));
        }
        return Integer.parseInt(param);
    }

    private boolean getBooleanParameter(Properties config, String parameter, boolean defaultValue) {
        String param = config.getProperty(this.mName + "." + parameter);
        if (param == null) {
            param = config.getProperty(parameter, Boolean.toString(defaultValue));
        }
        return Boolean.parseBoolean(param);
    }

    public void dispose() {
        HttpClientUtils.closeQuietly((HttpClient)this.mHttpClient);
    }

    public String getName() {
        return this.mName;
    }

    public Resource buildApplicationResource(URI relativeUri) throws WAApplicationClientException {
        return this.buildApplicationResource(relativeUri, null);
    }

    public Resource buildApplicationResource(URI relativeUri, Map<String, List<String>> headerOverrides) throws WAApplicationClientException {
        URI uri = UriResolver.resolve(this.getEndpoint(), relativeUri);
        LOG.info("Resolved path:" + uri.toString());
        return this.addWatsonHeaders(this.mRestClient.resource(uri), headerOverrides);
    }

    public URI getEndpoint() throws WAApplicationClientException {
        Map<String, List<String>> httpHeaders = this.mHeaderProvider.getHttpHeaders();
        String lbPath = null;
        switch (this.mGatewayMode) {
            case ssl: {
                lbPath = WatsonHeaders.getSSLWatsonGateway(httpHeaders);
                break;
            }
            case mutualSsl: {
                lbPath = WatsonHeaders.getMutualSSLWatsonGateway(httpHeaders);
                break;
            }
            default: {
                lbPath = WatsonHeaders.getWatsonGateway(httpHeaders);
            }
        }
        if (StringUtils.isBlank((String)lbPath)) {
            throw new WAApplicationClientException.InvalidRequest("No " + this.mGatewayMode.name() + " load balancer path was specified.");
        }
        try {
            return UriResolver.resolve(new URI(lbPath), new URI(this.mAppRoot));
        }
        catch (URISyntaxException e) {
            throw new WAApplicationClientException.InternalError("Unexpected URISyntaxException", e);
        }
    }

    private Resource addWatsonHeaders(Resource resource, Map<String, List<String>> overrides) throws WAApplicationClientException {
        Map<String, List<String>> httpHeaders = this.mHeaderProvider.getHttpHeaders();
        for (Map.Entry<String, List<String>> x : httpHeaders.entrySet()) {
            if (overrides != null && overrides.containsKey(x.getKey()) || !StringUtils.startsWith((String)x.getKey(), (String)"ba-")) continue;
            resource.header(x.getKey(), new String[]{x.getValue().get(0)});
        }
        if (overrides != null) {
            for (Map.Entry<String, List<String>> header : overrides.entrySet()) {
                if (header.getValue() == null) continue;
                for (String value : header.getValue()) {
                    resource.header(header.getKey(), new String[]{value});
                }
            }
        }
        return resource;
    }

    public void handleResponse(ClientResponse response, Response.Status expectedStatus) throws WAApplicationClientException.ApplicationError {
        this.handleResponse(response, expectedStatus, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T handleResponse(ClientResponse response, Response.Status expectedStatus, Class<T> responseType) throws WAApplicationClientException.ApplicationError {
        try {
            if (response.getStatusCode() == expectedStatus.getStatusCode()) {
                Object responseBody = null;
                if (responseType != null) {
                    responseBody = response.getEntity(responseType);
                }
                Object object = responseBody;
                return (T)object;
            }
            this.handleClientErrorResponse(response, expectedStatus);
        }
        finally {
            WAApplicationClient.consumeResponseQuietly(response);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleClientErrorResponse(ClientResponse response, Response.Status expectedStatus) throws WAApplicationClientException.ApplicationError {
        try {
            this.handleClientErrorResponse(expectedStatus.getStatusCode(), response.getStatusCode(), response.getMessage(), (String)response.getEntity(String.class));
        }
        finally {
            WAApplicationClient.consumeResponseQuietly(response);
        }
    }

    private void handleClientErrorResponse(int expectedStatusCode, int statusCode, String message, String body) throws WAApplicationClientException.ApplicationError {
        LOG.error("Expected status {} from {}; endpoint returned HTTP status {}: {}\n{}", new Object[]{expectedStatusCode, this.mAppRoot, statusCode, message, body});
        throw new WAApplicationClientException.ApplicationError("Unexpected error response from " + this.mAppRoot + ":" + message, statusCode, body);
    }

    public static void consumeResponseQuietly(ClientResponse response) {
        if (response != null) {
            try {
                response.consumeContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ClientConfig getClientConfig() {
        return this.mRestClient.getConfig();
    }

    public static enum GatewayMode {
        plaintext,
        ssl,
        mutualSsl;

    }
}

