/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.healthcheck.util;

import com.ibm.wa.webclient.healthcheck.util.HealthCheckItem;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="health")
public class HealthResponse {
    public static final String HEALTHY_STATUS = "healthy";
    public static final String UNHEALTHY_STATUS = "unhealthy";
    @XmlElementWrapper
    @XmlElement(name="item")
    private List<HealthCheckItem> healthcheckitems;
    @XmlElement(name="overall-status")
    private String overallStatus;

    public HealthResponse() {
    }

    public HealthResponse(List<HealthCheckItem> healthcheckitems) {
        this.healthcheckitems = healthcheckitems;
        this.overallStatus = this.computeOverallStatus(healthcheckitems);
    }

    private String computeOverallStatus(List<HealthCheckItem> items) {
        for (HealthCheckItem item : items) {
            if (!item.getStatus().equals(UNHEALTHY_STATUS)) continue;
            return UNHEALTHY_STATUS;
        }
        return HEALTHY_STATUS;
    }

    public List<HealthCheckItem> getList() {
        return this.healthcheckitems;
    }

    public void setList(List<HealthCheckItem> hrd) {
        this.healthcheckitems = hrd;
    }

    public void addHealthCheckItem(HealthCheckItem healthCheckItem) {
        this.healthcheckitems.add(healthCheckItem);
    }

    public String getOverallStatus() {
        return this.overallStatus;
    }

    public void setOverallStatus(String overallStatus) {
        this.overallStatus = overallStatus;
    }
}

