/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.swift.http;

import com.ibm.wa.webclient.swift.http.SwiftCredentials;
import java.util.Arrays;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.client.ClientParamsStack;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.util.CharArrayBuffer;

public class SwiftAuthScheme
extends AuthSchemeBase {
    public static final String SCHEME_NAME = "Swift";
    private boolean isComplete = false;
    HttpParams httpParams;

    public SwiftAuthScheme(HttpParams params) {
        this.httpParams = params;
    }

    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        if (null == credentials) {
            throw new AuthenticationException("No credentials provided.");
        }
        if (!SwiftCredentials.class.isAssignableFrom(credentials.getClass())) {
            throw new AuthenticationException("Programmer error: expected SwiftCredentials.");
        }
        SwiftCredentials creds = (SwiftCredentials)credentials;
        DefaultHttpClient client = new DefaultHttpClient();
        HttpGet get = new HttpGet(creds.getAuthUrl());
        get.addHeader("X-Auth-User", credentials.getUserPrincipal().getName());
        get.addHeader("X-Auth-Key", credentials.getPassword());
        HttpResponse authResponse = null;
        try {
            authResponse = client.execute((HttpUriRequest)get);
            this.isComplete = true;
            if (authResponse.getStatusLine().getStatusCode() == 200) {
                Header h = authResponse.getFirstHeader("X-Auth-Token");
                if (this.httpParams != null) {
                    ((ClientParamsStack)this.httpParams).getClientParams().setParameter("http.default-headers", Arrays.asList(h));
                }
                Header header = h;
                return header;
            }
        }
        catch (Exception e) {
            throw new AuthenticationException("Unable to complete authentication request.", (Throwable)e);
        }
        finally {
            HttpClientUtils.closeQuietly((HttpResponse)authResponse);
        }
        throw new AuthenticationException("Unauthorized");
    }

    public String getParameter(String parameter) {
        return null;
    }

    public String getRealm() {
        return "";
    }

    public String getSchemeName() {
        return SCHEME_NAME;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public boolean isConnectionBased() {
        return false;
    }

    protected void parseChallenge(CharArrayBuffer arg0, int arg1, int arg2) throws MalformedChallengeException {
        String[] args = arg0.toString().split(":", 2);
        if (args.length != 2) {
            throw new MalformedChallengeException(arg0.toString());
        }
        if (0 != args[0].toLowerCase().compareTo("WWW-Authenticate".toLowerCase())) {
            throw new MalformedChallengeException(arg0.toString());
        }
        if ((args = args[1].trim().split(" ", 2)).length != 2) {
            throw new MalformedChallengeException(arg0.toString());
        }
        if (0 != args[0].toLowerCase().compareTo(this.getSchemeName().toLowerCase())) {
            throw new MalformedChallengeException(arg0.toString());
        }
        if (!args[1].startsWith("realm=")) {
            throw new MalformedChallengeException(arg0.toString());
        }
    }
}

