/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.swift.http;

import com.ibm.wa.webclient.swift.http.SwiftCredentials;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.protocol.HttpContext;

public class SwiftHttpRequestInterceptor
implements HttpRequestInterceptor {
    URI auth_uri;
    String x_auth_user;
    String x_auth_key;

    boolean isAuthUrlRequest(HttpRequest request) {
        String host = request.getFirstHeader("host").getValue();
        String path = request.getRequestLine().getUri();
        return StringUtils.equals((String)this.auth_uri.getHost(), (String)host) && StringUtils.equals((String)this.auth_uri.getPath(), (String)path);
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (null == this.auth_uri) {
            CredentialsProvider provider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            if (null == provider) {
                return;
            }
            Credentials creds = provider.getCredentials(AuthScope.ANY);
            if (null == creds) {
                return;
            }
            if (!SwiftCredentials.class.isAssignableFrom(creds.getClass())) {
                return;
            }
            SwiftCredentials c = (SwiftCredentials)creds;
            this.auth_uri = URI.create(c.getAuthUrl());
            this.x_auth_user = c.getUserPrincipal().getName();
            this.x_auth_key = c.getPassword();
        }
        if (this.isAuthUrlRequest(request)) {
            request.addHeader("X-Auth-User", this.x_auth_user);
            request.addHeader("X-Auth-Key", this.x_auth_key);
        }
    }
}

