/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.util;

import com.ibm.wa.webclient.util.BasicHttpEntityEnclosingRequest;
import com.ibm.wa.webclient.util.BasicHttpRequest;
import com.ibm.wa.webclient.util.EmptyInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.BasicHeader;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.HandlerContext;
import org.apache.wink.client.internal.handlers.AbstractConnectionHandler;
import org.apache.wink.client.internal.handlers.ClientResponseImpl;

public class HttpClientConnectionHandler
extends AbstractConnectionHandler {
    private final HttpClient httpclient;

    public HttpClientConnectionHandler(HttpClient httpclient) {
        this.httpclient = httpclient;
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        HttpResponse response = this.handleRequest(request, context);
        return this.handleResponse(request, context, response);
    }

    private HttpResponse handleRequest(ClientRequest request, HandlerContext context) throws IOException, KeyManagementException, NoSuchAlgorithmException {
        IgnoreCloseOutputStream ncos;
        OutputStream os = ncos = new IgnoreCloseOutputStream();
        WriteableHttpEntity entity = null;
        if (request.getEntity() != null) {
            os = this.adaptOutputStream(os, request, context.getOutputStreamAdapters());
            entity = new WriteableHttpEntity(request, os, ncos);
        }
        HttpRequestBase entityRequest = this.prepareHttpRequest(request, this.httpclient, entity);
        return this.httpclient.execute((HttpUriRequest)entityRequest);
    }

    private HttpRequestBase prepareHttpRequest(ClientRequest request, HttpClient client, HttpEntity entity) {
        Object entityRequest;
        URI uri = request.getURI();
        String method = request.getMethod();
        Object httpRequest = null;
        if (entity == null) {
            httpRequest = entityRequest = new BasicHttpRequest(method);
        } else {
            entityRequest = new BasicHttpEntityEnclosingRequest(method);
            entityRequest.setEntity(entity);
            httpRequest = entityRequest;
        }
        httpRequest.setURI(uri);
        MultivaluedMap headers = request.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            for (String value : (List)entry.getValue()) {
                httpRequest.addHeader((String)entry.getKey(), value);
            }
        }
        return httpRequest;
    }

    private ClientResponse handleResponse(ClientRequest request, HandlerContext context, HttpResponse httpResponse) throws IllegalStateException, IOException {
        ClientResponse response = this.createResponse(request, httpResponse);
        HttpEntity entity = httpResponse.getEntity();
        InputStream is = null;
        is = entity == null ? new EmptyInputStream() : entity.getContent();
        is = this.adaptInputStream(is, response, context.getInputStreamAdapters());
        response.setEntity((Object)is);
        return response;
    }

    private ClientResponse createResponse(ClientRequest request, final HttpResponse httpResponse) {
        ClientResponseImpl response = new ClientResponseImpl();
        StatusLine statusLine = httpResponse.getStatusLine();
        response.setStatusCode(statusLine.getStatusCode());
        response.setMessage(statusLine.getReasonPhrase());
        response.getAttributes().putAll(request.getAttributes());
        response.setContentConsumer(new Runnable(){

            @Override
            public void run() {
                HttpEntity entity = httpResponse.getEntity();
                if (null != entity && entity.isStreaming()) {
                    try {
                        entity.getContent().close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        this.processResponseHeaders((ClientResponse)response, httpResponse);
        return response;
    }

    private void processResponseHeaders(ClientResponse response, HttpResponse httpResponse) {
        Header[] allHeaders;
        for (Header header : allHeaders = httpResponse.getAllHeaders()) {
            response.getHeaders().add((Object)header.getName(), (Object)header.getValue());
        }
    }

    private static class IgnoreCloseOutputStream
    extends OutputStream {
        private OutputStream os;

        private IgnoreCloseOutputStream() {
        }

        public void setOutputStream(OutputStream os) {
            this.os = os;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.os.write(b);
        }
    }

    private final class WriteableHttpEntity
    implements HttpEntity {
        private final ClientRequest request;
        private final OutputStream adaptedOutputStream;
        private final IgnoreCloseOutputStream ncos;

        public WriteableHttpEntity(ClientRequest request, OutputStream adaptedOutputStream, IgnoreCloseOutputStream ncos) {
            this.request = request;
            this.adaptedOutputStream = adaptedOutputStream;
            this.ncos = ncos;
        }

        public void consumeContent() throws IOException {
        }

        public InputStream getContent() throws IOException, IllegalStateException {
            return null;
        }

        public Header getContentEncoding() {
            MultivaluedMap headers = this.request.getHeaders();
            if (headers.containsKey((Object)"Content-Encoding")) {
                return new BasicHeader("Content-Encoding", (String)headers.getFirst((Object)"Content-Encoding"));
            }
            return null;
        }

        public long getContentLength() {
            return -1L;
        }

        public Header getContentType() {
            MultivaluedMap headers = this.request.getHeaders();
            if (headers.containsKey((Object)"Content-Type")) {
                return new BasicHeader("Content-Type", (String)headers.getFirst((Object)"Content-Type"));
            }
            return null;
        }

        public boolean isChunked() {
            return true;
        }

        public boolean isRepeatable() {
            return true;
        }

        public boolean isStreaming() {
            return true;
        }

        public void writeTo(OutputStream os) throws IOException {
            this.ncos.setOutputStream(os);
            HttpClientConnectionHandler.this.writeEntity(this.request, this.adaptedOutputStream);
        }
    }
}

