/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.NullArgumentException;

public class HttpDateParser {
    private static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    private final SimpleDateFormat mRfc822Format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss ZZZ", Locale.US);
    private final SimpleDateFormat mRfc850Format = new SimpleDateFormat("EEEE, dd-MMM-yy HH:mm:ss ZZZ", Locale.US);
    private final SimpleDateFormat mAnsiICFormat = new SimpleDateFormat("EEE MMM d HH:mm:ss yyyy", Locale.US);

    public HttpDateParser() {
        this.mRfc822Format.getCalendar().setTimeZone(GMT);
        this.mRfc822Format.setLenient(false);
        this.mRfc850Format.getCalendar().setTimeZone(GMT);
        this.mRfc850Format.setLenient(false);
        this.mAnsiICFormat.getCalendar().setTimeZone(GMT);
        this.mAnsiICFormat.setLenient(false);
    }

    public Date parse(String text) throws ParseException {
        if (null == text) {
            throw new NullArgumentException("text");
        }
        if (text.isEmpty()) {
            throw new IllegalArgumentException("Text was empty");
        }
        ParsePosition ppos = new ParsePosition(0);
        Date d = this.mRfc822Format.parse(text, ppos);
        if (null != d && ppos.getErrorIndex() == -1) {
            return d;
        }
        ppos.setIndex(0);
        ppos.setErrorIndex(-1);
        d = this.mRfc850Format.parse(text, ppos);
        if (null != d && ppos.getErrorIndex() == -1) {
            return d;
        }
        ppos.setIndex(0);
        ppos.setErrorIndex(-1);
        d = this.mAnsiICFormat.parse(text, ppos);
        if (null != d && ppos.getErrorIndex() == -1) {
            return d;
        }
        throw new ParseException("Failed to parse HTTP-date", -1);
    }
}

