/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.util;

import com.ibm.wa.webclient.util.LenientHttpRequestRetryHandler;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;

public class PoolingHttpClientBuilder {
    public static final int INIFINITE_TTL = -1;
    public static final int INFINITE_TIMEOUT = 0;
    private int connectionTotal = 20;
    private int connectionRouteTotal = 20;
    private int connectionTTL = 300000;
    private int connectTimeout = 90000;
    private int soTimeout = 0;
    private HttpParams defaultHttpParams = null;
    private SchemeRegistry schemeRegistry = SchemeRegistryFactory.createDefault();

    public PoolingHttpClientBuilder withConnectionTotal(int connectionTotal) {
        if (connectionTotal <= 0) {
            throw new IllegalArgumentException("connectionTotal <= 0");
        }
        this.connectionTotal = connectionTotal;
        return this;
    }

    public PoolingHttpClientBuilder withConnectionRouteTotal(int connectionRouteTotal) {
        if (connectionRouteTotal <= 0) {
            throw new IllegalArgumentException("connectionRouteTotal <= 0");
        }
        this.connectionRouteTotal = connectionRouteTotal;
        return this;
    }

    public PoolingHttpClientBuilder withConnectionTTL(int connectionTTL) {
        this.connectionTTL = connectionTTL;
        return this;
    }

    public PoolingHttpClientBuilder withConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout < 0");
        }
        this.connectTimeout = connectTimeout;
        return this;
    }

    public PoolingHttpClientBuilder withSoTimeout(int soTimeout) {
        if (soTimeout < 0) {
            throw new IllegalArgumentException("soTimeout < 0");
        }
        this.soTimeout = soTimeout;
        return this;
    }

    public PoolingHttpClientBuilder withDefaultHttpParams(HttpParams defaultHttpParams) {
        this.defaultHttpParams = defaultHttpParams;
        return this;
    }

    public PoolingHttpClientBuilder withSchemaRegistry(SchemeRegistry schemaRegistry) {
        this.schemeRegistry = schemaRegistry;
        return this;
    }

    public PoolingHttpClientBuilder withSchemePortTLSProtocols(String scheme, int port, String ... protocols) {
        if (null == this.schemeRegistry) {
            this.schemeRegistry = SchemeRegistryFactory.createDefault();
        }
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, PoolingHttpClientBuilder.getTrustingManager(), new SecureRandom());
            CustomizedSSLSocketFactory socketFactory = new CustomizedSSLSocketFactory(sc, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER, protocols);
            Scheme sch = new Scheme(scheme, port, (SchemeSocketFactory)socketFactory);
            this.schemeRegistry.register(sch);
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (KeyManagementException e) {
            // empty catch block
        }
        return this;
    }

    private static TrustManager[] getTrustingManager() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        return trustAllCerts;
    }

    public HttpClient build() {
        PoolingClientConnectionManager connMan = new PoolingClientConnectionManager(this.schemeRegistry, (long)this.connectionTTL, TimeUnit.MILLISECONDS);
        connMan.setDefaultMaxPerRoute(this.connectionRouteTotal);
        connMan.setMaxTotal(this.connectionTotal);
        HttpParams httpParams = this.defaultHttpParams;
        if (null == httpParams) {
            httpParams = new BasicHttpParams();
        }
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.connectTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)this.soTimeout);
        HttpConnectionParams.setSoKeepalive((HttpParams)httpParams, (boolean)true);
        HttpProtocolParams.setHttpElementCharset((HttpParams)httpParams, (String)"UTF-8");
        DefaultHttpClient client = new DefaultHttpClient((ClientConnectionManager)connMan, httpParams);
        client.setHttpRequestRetryHandler((HttpRequestRetryHandler)new LenientHttpRequestRetryHandler());
        return client;
    }

    static class CustomizedSSLSocketFactory
    extends SSLSocketFactory {
        private String[] tlsProtocols;

        public CustomizedSSLSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier, String ... tlsProtocols) {
            super(sslContext, hostnameVerifier);
            if (null != tlsProtocols) {
                this.tlsProtocols = tlsProtocols;
            }
        }

        protected void prepareSocket(SSLSocket socket) {
            if (null != this.tlsProtocols) {
                socket.setEnabledProtocols(this.tlsProtocols);
            }
        }
    }
}

