/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.util;

import com.ibm.wa.webclient.util.HttpClientConfig;
import javax.ws.rs.core.Application;
import org.apache.http.client.HttpClient;
import org.apache.wink.client.ClientConfig;
import org.apache.wink.client.RestClient;
import org.apache.wink.client.handlers.ClientHandler;

public class RestClientBuilder {
    private HttpClient httpClient = null;
    private Application[] applications = null;
    private ClientHandler[] handlers = null;
    private boolean followRedirects = true;
    private boolean bypassHostnameVerification = false;

    public RestClientBuilder withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public RestClientBuilder withApplications(Application ... applications) {
        this.applications = applications;
        return this;
    }

    public RestClientBuilder withHandlers(ClientHandler ... handlers) {
        this.handlers = handlers;
        return this;
    }

    public RestClientBuilder withFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public RestClientBuilder withBypassHostnameVerification(boolean bypass) {
        this.bypassHostnameVerification = bypass;
        return this;
    }

    public RestClient build() {
        ClientConfig config = null;
        config = null != this.httpClient ? new HttpClientConfig(this.httpClient) : new ClientConfig();
        if (null != this.applications) {
            config.applications(this.applications);
        }
        if (null != this.handlers && this.handlers.length > 0) {
            config.handlers(this.handlers);
        }
        config.followRedirects(this.followRedirects);
        config.setBypassHostnameVerification(this.bypassHostnameVerification);
        return new RestClient(config);
    }
}

