/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedRetryStrategy
implements ServiceUnavailableRetryStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(RuleBasedRetryStrategy.class);
    private final long retryInternval;
    private final Map<Integer, Integer> statusCode2MaxRetryAttemtps = new HashMap<Integer, Integer>();

    public RuleBasedRetryStrategy(long retryInterval) {
        this.retryInternval = retryInterval;
    }

    public RuleBasedRetryStrategy addRule(int statusCode, int maxRetryAttempts) {
        this.statusCode2MaxRetryAttemtps.put(statusCode, maxRetryAttempts);
        return this;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        Integer maxRetryAttempts = this.statusCode2MaxRetryAttemtps.get(response.getStatusLine().getStatusCode());
        if (null == maxRetryAttempts) {
            return false;
        }
        if (executionCount <= maxRetryAttempts) {
            LOGGER.info("Retrying failed request (attempt {} of {})", (Object)executionCount, (Object)maxRetryAttempts);
            return true;
        }
        return false;
    }

    public long getRetryInterval() {
        return this.retryInternval;
    }
}

