/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.util;

import com.ibm.wa.webclient.util.WatsonHeaders;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.NullArgumentException;

public abstract class WAIdentityHelper {
    private static final String BA_SSO_USER_VALUE = "uid=_impersonator_;mail=nobody@ibm.com;cn=wa.ibm.com";
    private static final String BA_SSO_AUTHENTICITY_VALUE = "youcantrustme";
    public static final String SCX_SUBSCRIPTION_TID = "tid";
    public static final String SCX_SUBSCRIPTION_USERID = "userid";
    public static final String SCX_SUBSCRIPTION_ACCOUNTID = "accountid";

    public static Map<String, List<String>> makeAuthHeaders(String scxTenantId, String scxUserId, List<String> subscriptionHeaders) {
        if (null == scxTenantId) {
            throw new NullArgumentException("scxTenantId");
        }
        if (null == scxUserId) {
            throw new NullArgumentException("scxUserId");
        }
        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
        try {
            headerMap.put("ba-sso-user", Arrays.asList(URLEncoder.encode(BA_SSO_USER_VALUE, "UTF-8")));
            headerMap.put("ba-sso-authenticity", Arrays.asList(BA_SSO_AUTHENTICITY_VALUE));
            headerMap.put("ba-scx-subscription", Arrays.asList(URLEncoder.encode(String.format("tid=%s;userid=%s;%s", scxTenantId, scxUserId, WAIdentityHelper.scrubSubscriptionHeader(subscriptionHeaders)), "UTF-8")));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return headerMap;
    }

    private static String scrubSubscriptionHeader(List<String> subscriptionHeaders) {
        if (subscriptionHeaders == null || subscriptionHeaders.isEmpty()) {
            return "";
        }
        String header = subscriptionHeaders.size() > 0 ? subscriptionHeaders.get(0) : "";
        Properties pairs = WatsonHeaders.decodeKeyValuePairs(header);
        StringBuilder builder = new StringBuilder();
        for (Object key : pairs.keySet()) {
            String strKey = (String)key;
            if (strKey.startsWith(SCX_SUBSCRIPTION_TID) || strKey.startsWith(SCX_SUBSCRIPTION_USERID)) continue;
            builder.append(strKey).append('=').append(pairs.getProperty(strKey)).append(';');
        }
        return builder.toString();
    }
}

