/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.HttpHeaders;
import org.apache.commons.lang.StringUtils;

public class WatsonHeaders {
    public static final String BA_SSO_USER = "ba-sso-user";
    public static final String BA_SSO_AUTHENTICITY = "ba-sso-authenticity";
    public static final String BA_SUBSCRIPTION = "ba-subscription";
    public static final String BA_SCX_SUBSCRIPTION = "ba-scx-subscription";
    public static final String BA_WATSON_GATEWAY = "ba-watson-gateway";
    public static final String BA_TRANSACTION = "ba-transaction";
    public static final String BA_DIAGNOSTICS = "ba-diagnostics";
    @Deprecated
    public static final String BA_LOCALE = "ba-locales";
    public static final String BA_LOCALES = "ba-locales";
    private static final String BA_PREFIX = "ba-";
    private static final Pattern PAIR_DELIM_PATTERN = Pattern.compile(";");
    private static final Pattern KV_DELIM_PATTERN = Pattern.compile("=");

    public static Map<String, List<String>> getWatsonHeaders(HttpServletRequest request) {
        HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
        if (request != null) {
            Enumeration enumHeaders = request.getHeaderNames();
            while (enumHeaders.hasMoreElements()) {
                String key = ((String)enumHeaders.nextElement()).toLowerCase();
                if (!StringUtils.startsWith((String)key, (String)BA_PREFIX)) continue;
                headers.put(key, Collections.list(request.getHeaders(key)));
            }
        }
        return headers;
    }

    public static Map<String, List<String>> getWatsonHeaders(HttpHeaders headers) {
        if (headers != null) {
            return WatsonHeaders.getWatsonHeaders((Map<String, List<String>>)headers.getRequestHeaders());
        }
        return Collections.emptyMap();
    }

    public static Map<String, List<String>> getWatsonHeaders(Map<String, List<String>> headers) {
        HashMap<String, List<String>> answer = new HashMap<String, List<String>>();
        if (headers != null) {
            for (Map.Entry<String, List<String>> e : headers.entrySet()) {
                String key = e.getKey().toLowerCase();
                if (!StringUtils.startsWith((String)key, (String)BA_PREFIX)) continue;
                answer.put(key, new ArrayList(e.getValue()));
            }
        }
        return answer;
    }

    public static List<String> getAllValues(Map<String, List<String>> headers, String name, boolean decodeUrl) {
        List<String> values;
        ArrayList<String> answer = new ArrayList<String>();
        if (headers != null && (values = headers.get(name.toLowerCase())) != null) {
            for (String v : values) {
                if (decodeUrl) {
                    v = WatsonHeaders.decodeURL(v);
                }
                answer.add(v);
            }
        }
        return answer;
    }

    public static String getFirstValue(Map<String, List<String>> headers, String name, boolean decodeUrl) {
        List<String> values;
        String answer = null;
        if (headers != null && null != (values = headers.get(name.toLowerCase())) && values.size() > 0) {
            answer = values.get(0);
            if (decodeUrl) {
                answer = WatsonHeaders.decodeURL(answer);
            }
        }
        return answer;
    }

    public static String decodeURL(String value) {
        if (null == value) {
            return null;
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Failed to URL encode value:" + value, ex);
        }
    }

    public static String encodeURL(String value) {
        if (null == value) {
            return null;
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Failed to URL decode value: " + value, ex);
        }
    }

    public static Properties decodeKeyValuePairs(String value) {
        Properties props = new Properties();
        if (!StringUtils.isEmpty((String)value)) {
            for (String pair : PAIR_DELIM_PATTERN.split(value)) {
                String[] kv = KV_DELIM_PATTERN.split(pair.trim(), 2);
                if (kv.length != 2 || StringUtils.isEmpty((String)kv[0]) || StringUtils.isEmpty((String)kv[1])) continue;
                props.put(kv[0], kv[1]);
            }
        }
        return props;
    }

    public static String encodeKeyValuePairs(Map<?, ?> pairs) {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<?, ?> e : pairs.entrySet()) {
            builder.append(e.getKey()).append('=').append(e.getValue()).append(';');
        }
        return builder.toString();
    }

    public static String getWatsonGateway(Map<String, List<String>> headers) {
        return WatsonHeaders.getWatsonGateway(headers, "location");
    }

    public static String getSSLWatsonGateway(Map<String, List<String>> headers) {
        return WatsonHeaders.getWatsonGateway(headers, "sslLocation");
    }

    public static String getMutualSSLWatsonGateway(Map<String, List<String>> headers) {
        return WatsonHeaders.getWatsonGateway(headers, "mutualSslLocation");
    }

    private static String getWatsonGateway(Map<String, List<String>> headers, String locationKey) {
        String gatewayHeader = WatsonHeaders.getFirstValue(headers, BA_WATSON_GATEWAY, true);
        if (gatewayHeader == null) {
            return "";
        }
        Properties kvPairs = WatsonHeaders.decodeKeyValuePairs(gatewayHeader);
        if (!kvPairs.containsKey(locationKey) || !kvPairs.containsKey("lbpath")) {
            return null;
        }
        return kvPairs.getProperty(locationKey) + kvPairs.getProperty("lbpath");
    }

    public static Properties getTransactionIds(Map<String, List<String>> headers) {
        String transactionHeader = WatsonHeaders.getFirstValue(headers, BA_TRANSACTION, true);
        if (transactionHeader == null) {
            return new Properties();
        }
        return WatsonHeaders.decodeKeyValuePairs(transactionHeader);
    }

    public static Properties getScxSubscriptionFields(Map<String, List<String>> headers) {
        String scxSubscriptionHeader = WatsonHeaders.getFirstValue(headers, BA_SCX_SUBSCRIPTION, true);
        if (scxSubscriptionHeader == null) {
            return new Properties();
        }
        return WatsonHeaders.decodeKeyValuePairs(scxSubscriptionHeader);
    }

    public static Properties getDiagnostics(Map<String, List<String>> headers) {
        String diagnosticsHeader = WatsonHeaders.getFirstValue(headers, BA_DIAGNOSTICS, true);
        if (diagnosticsHeader == null) {
            return new Properties();
        }
        return WatsonHeaders.decodeKeyValuePairs(diagnosticsHeader);
    }

    public static Properties getLocales(Map<String, List<String>> headers) {
        String localesHeader = WatsonHeaders.getFirstValue(headers, "ba-locales", true);
        if (localesHeader == null) {
            return new Properties();
        }
        return WatsonHeaders.decodeKeyValuePairs(localesHeader);
    }
}

