/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.wink;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.AbstractAuthSecurityHandler;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreemptiveBasicAuthSecurityHandler
extends AbstractAuthSecurityHandler
implements ClientHandler {
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final Logger LOG = LoggerFactory.getLogger(PreemptiveBasicAuthSecurityHandler.class);

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        MultivaluedMap headers = request.getHeaders();
        if (headers != null && !headers.containsKey((Object)AUTHORIZATION_HEADER)) {
            if (this.handlerEncodedCredentials == null) {
                if (this.handlerUsername == null || this.handlerPassword == null) {
                    LOG.error("Handler is not initialized with both a user name and a password.");
                    throw new ClientAuthenticationException("Handler is not initialized with both a user name and a password.");
                }
                this.handlerEncodedCredentials = PreemptiveBasicAuthSecurityHandler.getEncodedString((String)this.handlerUsername, (String)this.handlerPassword);
                LOG.info("Setting Authorization header to '" + this.handlerEncodedCredentials + "'.");
            }
            headers.putSingle((Object)AUTHORIZATION_HEADER, (Object)this.handlerEncodedCredentials);
        }
        return context.doChain(request);
    }
}

