/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wa.webclient.wink;

import com.ibm.json.java.JSONObject;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.wink.client.ClientRequest;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.handlers.ClientHandler;
import org.apache.wink.client.handlers.HandlerContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwiftUrlHandler
implements ClientHandler {
    private String xAuthToken = null;
    private String xStorageUrl = null;
    private String swiftAuthUrl = null;
    private String xAuthUser = null;
    private String xAuthKey = null;
    private String xScope = null;
    private long mAuthExpires;
    private long mLastAuthTimeNanos;
    private static final transient Logger LOG = LoggerFactory.getLogger(SwiftUrlHandler.class);

    public SwiftUrlHandler(String swiftAuthUrl, String xAuthUser, String xAuthKey) {
        this(swiftAuthUrl, xAuthUser, xAuthKey, "");
    }

    public SwiftUrlHandler(String swiftAuthUrl, String xAuthUser, String xAuthKey, String xScope) {
        this.swiftAuthUrl = swiftAuthUrl;
        this.xAuthUser = xAuthUser;
        this.xAuthKey = xAuthKey;
        this.xScope = xScope;
    }

    public ClientResponse handle(ClientRequest request, HandlerContext context) throws Exception {
        LOG.debug("Enter handle " + request.getMethod() + " " + request.getURI());
        URI uri = request.getURI();
        if (uri.getScheme().compareTo("swift") != 0) {
            return context.doChain(request);
        }
        this.authenticateIfRequired(request, context);
        URI newUri = UriBuilder.fromPath((String)this.xStorageUrl).path(uri.getPath()).replaceQuery(uri.getRawQuery()).build(new Object[0]);
        request.setURI(newUri);
        request.getHeaders().add((Object)"x-auth-token", (Object)this.xAuthToken);
        ClientResponse response = context.doChain(request);
        LOG.debug("Exit handle " + request.getMethod() + " " + request.getURI());
        return response;
    }

    protected void authenticateIfRequired(ClientRequest request, HandlerContext context) throws Exception {
        long secondsSinceLastAuth;
        if (null == this.xAuthToken) {
            this.authenticate(request, context);
        }
        if ((secondsSinceLastAuth = TimeUnit.NANOSECONDS.toSeconds(System.nanoTime() - this.mLastAuthTimeNanos)) > 3L * this.mAuthExpires / 4L) {
            this.authenticate(request, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void authenticate(ClientRequest request, HandlerContext context) throws Exception {
        ClientResponse response = null;
        String method = request.getMethod();
        URI uri = request.getURI();
        Object entity = request.getEntity();
        try {
            request.setEntity(null);
            request.setMethod("GET");
            request.setURI(URI.create(this.swiftAuthUrl));
            request.getHeaders().add((Object)"X-Auth-User", (Object)this.xAuthUser);
            request.getHeaders().add((Object)"X-Auth-Key", (Object)this.xAuthKey);
            response = context.doChain(request);
            this.xAuthToken = (String)response.getHeaders().getFirst((Object)"x-auth-token");
            this.xStorageUrl = SwiftUrlHandler.getStorageUrl(response, this.xScope);
            String tmp = (String)response.getHeaders().getFirst((Object)"x-auth-token-expires");
            this.mAuthExpires = StringUtils.isNumeric((String)tmp) ? Long.parseLong(tmp) : TimeUnit.HOURS.toSeconds(5L);
            this.mLastAuthTimeNanos = System.nanoTime();
        }
        finally {
            if (null != response) {
                response.consumeContent();
                request.setMethod(method);
                request.setURI(uri);
                request.setEntity(entity);
            }
        }
    }

    protected static String getStorageUrl(ClientResponse response) {
        return SwiftUrlHandler.getStorageUrl(response, "");
    }

    protected static String getStorageUrl(ClientResponse response, String scope) {
        String answer = (String)response.getHeaders().getFirst((Object)"x-storage-url");
        String length = (String)response.getHeaders().getFirst((Object)"content-length");
        if (!StringUtils.isNumeric((String)length)) {
            return answer;
        }
        if (!StringUtils.equals((String)((String)response.getHeaders().getFirst((Object)"content-type")), (String)"application/json")) {
            return answer;
        }
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        if (!json.containsKey((Object)"storage")) {
            return answer;
        }
        JSONObject storage = (JSONObject)json.get((Object)"storage");
        String tmpScope = scope;
        if (StringUtils.isEmpty((String)tmpScope) && storage.containsKey((Object)"default")) {
            tmpScope = (String)storage.get((Object)"default");
        }
        if (storage.containsKey((Object)tmpScope)) {
            answer = (String)storage.get((Object)tmpScope);
        }
        return answer;
    }
}

