/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security;

import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.security.SubjectHelper;
import com.ibm.neo.security.shiro.WASubject;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.ThreadContext;

public abstract class ACSHelper {
    public static Map<String, List<String>> getCurrentHttpHeaders() {
        Subject subject = ThreadContext.getSubject();
        return ACSHelper.getHttpHeaders(subject);
    }

    public static Map<String, List<String>> getHttpHeaders(Subject subject) {
        if (null == subject) {
            return Collections.emptyMap();
        }
        Map headers = null;
        if (subject instanceof WASubject) {
            headers = (Map)((WASubject)subject).getAttribute("BA.Headers");
        }
        if (null == headers) {
            headers = (Map)SubjectHelper.getSessionAttribute((Subject)subject, (String)"http.headers", Map.class, (boolean)false);
        }
        if (null == headers) {
            return Collections.emptyMap();
        }
        return headers;
    }

    public static void setHttpHeaders(Subject subject, Map<String, List<String>> headers) {
        if (subject instanceof WASubject) {
            ((WASubject)subject).setAttribute("BA.Headers", headers);
        }
        SubjectHelper.setSessionAttribute((Subject)subject, (String)"http.headers", headers);
    }

    public static IONObjectId getCurrentAccountId() {
        Subject subject = ThreadContext.getSubject();
        return ACSHelper.getAccountId(subject);
    }

    public static IONObjectId getAccountId(Subject subject) {
        if (null == subject) {
            return null;
        }
        String accountId = (String)SubjectHelper.getSessionAttribute((Subject)subject, (String)"account.id", String.class, (boolean)false);
        if (null == accountId) {
            return null;
        }
        return new IONObjectId(accountId);
    }

    public static IONObjectId getCurrentTenantId() {
        Subject subject = ThreadContext.getSubject();
        return ACSHelper.getTenantId(subject);
    }

    public static IONObjectId getTenantId(Subject subject) {
        if (null == subject) {
            return null;
        }
        String tenantId = (String)SubjectHelper.getSessionAttribute((Subject)subject, (String)"tenant.id", String.class, (boolean)false);
        if (null == tenantId) {
            return null;
        }
        return new IONObjectId(tenantId);
    }

    public static IONObjectId getCurrentUserId() {
        Subject subject = ThreadContext.getSubject();
        return ACSHelper.getUserId(subject);
    }

    public static IONObjectId getUserId(Subject subject) {
        if (null == subject) {
            return null;
        }
        String userId = (String)SubjectHelper.getSessionAttribute((Subject)subject, (String)"user.id", String.class, (boolean)false);
        if (null == userId) {
            return null;
        }
        return new IONObjectId(userId);
    }

    public static Serializable getCurrentSessionId() {
        Subject subject = ThreadContext.getSubject();
        return ACSHelper.getSessionId(subject);
    }

    public static Serializable getSessionId(Subject subject) {
        if (null == subject) {
            return null;
        }
        return SubjectHelper.getSessionId((Subject)subject, (boolean)false);
    }
}

