/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security;

import com.ibm.neo.event.EventSupport;
import com.ibm.neo.persist.ETenantContentModel;
import com.ibm.neo.persist.PersistenceException;
import com.ibm.neo.persist.ProjectionBuilder;
import com.ibm.neo.persist.QueryBuilder;
import com.ibm.neo.persist.UpdateBuilder;
import com.ibm.neo.persist.ion.IONObject;
import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.persist.nobject.Nobject;
import com.ibm.neo.persist.nobject.NobjectCollection;
import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.security.PostLogonListener;
import com.ibm.neo.security.UserDeleteListener;
import com.ibm.neo.security.capability.mongo.DefaultRoleSetup;
import com.ibm.neo.security.capability.mongo.MongoRoleAndCapabilityManipulator;
import com.ibm.neo.security.nodel.ACSPersistence;
import com.ibm.neo.security.nodel.Account;
import com.ibm.neo.security.nodel.Group;
import com.ibm.neo.security.nodel.Role;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.security.nodel.User;
import com.ibm.neo.security.nodel.UserOrGroup;
import com.ibm.neo.security.nodel.wa.WAAccount;
import com.ibm.neo.security.nodel.wa.WATenant;
import com.ibm.neo.security.nodel.wa.WAUser;
import com.ibm.neo.security.persistence.GeneralPersistenceException;
import com.ibm.neo.security.shiro.WASessionIdGenerator;
import com.ibm.neo.security.shiro.WASubject;
import com.ibm.neo.upgrade.ContentVersion;
import com.ibm.neo.util.Assertions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang.NullArgumentException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionException;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.SubjectThreadState;
import org.apache.shiro.util.Destroyable;
import org.apache.shiro.util.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessControlService {
    public static final IONObjectId ANONYMOUS_ID = new IONObjectId("000000000000000000000000");
    public static final String ANONYMOUS_PRINCIPAL = "__anonymous__";
    public static final String IMPERSONATOR_PRINCIPAL = "__impersonator__";
    public static final String NOBODY_PRINCIPAL = "__nobody__";
    public static final String ANONYMOUS_TAI_USERID = "__anonymous_user__";
    public static final String ANONYMOUS_TAI_TENANTID = "__anonymous_tenant__";
    public static final String ANONYMOUS_TAI_EMAIL = "anonymous@anonymous.wa.ibm.com";
    public static final String PROP_ANONYMOUS_ALLOWED = "com.ibm.neo.security.anonymous-allowed";
    public static final String PROP_SHIRO_MANAGED = "com.ibm.neo.security.shiro.managed";
    public static final String PROP_SHIRO_INI_RESOURCE_PATH = "com.ibm.neo.security.shiro.ini-resource-path";
    public static final String PROP_SECRET_STORE_FACTORY = "com.ibm.security.secret-store.factory";
    private static final String DEFAULT_SHIRO_INI_RESOURCE_PATH = "classpath:shiro.ini";
    public static final String PROP_DEFAULT_TENANT_CONTENT_MODEL = "com.ibm.neo.security.default-tenant-content-model";
    private static final String DEFAULT_TENANT_CONTENT_MODEL = ETenantContentModel.SHARED.name();
    private static final String SYS_PROP_CREATE_PRO_READY_TENANTS = "create.pro.ready.tenants";
    private static final String DEFAULT_CREATE_PRO_READY_TENANTS = "false";
    private static final Logger LOGGER = LoggerFactory.getLogger(AccessControlService.class);
    private static AccessControlService s_instance = null;
    private final Properties m_configuration;
    private final boolean m_managingShiro;
    private final boolean m_anonymousAllowed;
    private final ETenantContentModel m_defaultContentModel;
    private final EventSupport<PostLogonListener> m_logonListener = EventSupport.create(PostLogonListener.class);
    private final EventSupport<UserDeleteListener> m_userDeleteListener = EventSupport.create(UserDeleteListener.class);

    public static boolean isInitialized() {
        return null != s_instance;
    }

    public static void initialize(Properties _config) throws Exception {
        if (null != s_instance) {
            throw new IllegalStateException("AccessControlService was already initialized.");
        }
        s_instance = new AccessControlService(_config);
        s_instance.onInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void terminate() {
        if (null != s_instance) {
            try {
                s_instance.onTerminate();
            }
            finally {
                s_instance = null;
            }
        }
    }

    public static AccessControlService getInstance() {
        if (null == s_instance) {
            throw new IllegalStateException("AccessControlService was not initialized.");
        }
        return s_instance;
    }

    AccessControlService() throws Exception {
        this.m_managingShiro = false;
        this.m_defaultContentModel = null;
        this.m_configuration = null;
        this.m_anonymousAllowed = false;
    }

    AccessControlService(Properties _configuration) throws Exception {
        if (null == _configuration) {
            throw new NullArgumentException("configuration");
        }
        this.m_configuration = new Properties(_configuration);
        this.m_anonymousAllowed = "true".equals(this.m_configuration.getProperty(PROP_ANONYMOUS_ALLOWED, "true"));
        this.m_defaultContentModel = ETenantContentModel.valueOf((String)this.m_configuration.getProperty(PROP_DEFAULT_TENANT_CONTENT_MODEL, DEFAULT_TENANT_CONTENT_MODEL).toUpperCase());
        this.m_managingShiro = "true".equals(this.m_configuration.getProperty(PROP_SHIRO_MANAGED, "true"));
        if (this.m_managingShiro) {
            String shiroIniResPath = this.m_configuration.getProperty(PROP_SHIRO_INI_RESOURCE_PATH, DEFAULT_SHIRO_INI_RESOURCE_PATH);
            IniSecurityManagerFactory factory = new IniSecurityManagerFactory(shiroIniResPath);
            SecurityManager securityManager = (SecurityManager)factory.getInstance();
            SecurityUtils.setSecurityManager((SecurityManager)securityManager);
        }
    }

    void onInit() throws Exception {
        this.setupAnonymous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTerminate() {
        if (this.m_managingShiro) {
            try {
                SecurityManager secMan = SecurityUtils.getSecurityManager();
                if (secMan instanceof Destroyable) {
                    ((Destroyable)secMan).destroy();
                }
            }
            catch (Exception exception) {
            }
            finally {
                SecurityUtils.setSecurityManager(null);
            }
        }
    }

    public Properties getConfiguration() {
        return this.m_configuration;
    }

    public boolean isAnonymousAllowed() {
        return this.m_anonymousAllowed;
    }

    public boolean isAuthenticated() {
        Subject subject = ThreadContext.getSubject();
        if (null == subject) {
            return false;
        }
        return subject.isAuthenticated();
    }

    public boolean isSessionValid() {
        Subject subject = ThreadContext.getSubject();
        if (null == subject) {
            return false;
        }
        try {
            Session session = subject.getSession(false);
            if (null == session) {
                return false;
            }
            session.touch();
        }
        catch (SessionException ex) {
            return false;
        }
        return true;
    }

    public boolean isAnonymousExternalUser(String _externalUserId) {
        return ANONYMOUS_PRINCIPAL.equals(_externalUserId) || ANONYMOUS_TAI_USERID.equals(_externalUserId);
    }

    public String mapExternalUserId(String _externalUserId) {
        try {
            if (this.isAnonymousExternalUser(_externalUserId)) {
                return ANONYMOUS_ID.getIdentifier();
            }
            NobjectCollection userCol = ACSPersistence.getUsersCollection();
            IONObject user = userCol.getDocumentCollection().findOne(new QueryBuilder().equalTo("external-user-id", (Object)_externalUserId.toLowerCase()).toDocument(), new ProjectionBuilder().include(new String[]{"_id"}).toDocument());
            if (null == user) {
                return null;
            }
            return user.getIONObjectId("_id").getIdentifier();
        }
        catch (PersistenceException ex) {
            return null;
        }
    }

    public void addLogonListener(PostLogonListener _listener) {
        this.m_logonListener.add((Object)_listener);
    }

    public void removeLogonListener(PostLogonListener _listener) {
        this.m_logonListener.remove((Object)_listener);
    }

    public void addUserDeleteListener(UserDeleteListener _listener) {
        this.m_userDeleteListener.add((Object)_listener);
    }

    public void removeUserDeleteListener(UserDeleteListener _listener) {
        this.m_userDeleteListener.remove((Object)_listener);
    }

    public Subject logon(AuthenticationToken _authenticationToken) {
        return this.logon(_authenticationToken, true, null);
    }

    public Subject logon(AuthenticationToken _authenticationToken, boolean _bind) {
        return this.logon(_authenticationToken, _bind, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject logon(AuthenticationToken _authenticationToken, boolean _bind, Serializable _sessionId) {
        WASubject.Builder builder = new WASubject.Builder();
        builder.sessionCreationEnabled(true);
        if (null != _sessionId) {
            WASessionIdGenerator.setLocalSessionId(_sessionId);
        }
        try {
            WASubject subject = builder.buildWASubject();
            boolean success = false;
            try {
                this.logon(subject, _authenticationToken);
                if (_bind) {
                    ThreadContext.bind((Subject)subject);
                }
                success = true;
            }
            finally {
                if (!success) {
                    subject.logout();
                }
            }
            WASubject wASubject = subject;
            return wASubject;
        }
        finally {
            WASessionIdGenerator.clearLocalSessionId();
        }
    }

    public Subject logon(Subject subject, AuthenticationToken authenticationToken) {
        LOGGER.trace("Started logon with authentication token ({})", (Object)authenticationToken);
        subject.login(authenticationToken);
        this.doPostLogon(subject);
        return subject;
    }

    public Subject resumeSession(Serializable _sessionId, boolean _bind) {
        LOGGER.trace("Started resuming session ({})", (Object)_sessionId);
        try {
            WASubject.Builder builder = new WASubject.Builder();
            builder.sessionCreationEnabled(false);
            builder.sessionId(_sessionId);
            WASubject subject = builder.buildWASubject();
            Session session = subject.getSession(false);
            if (null == session) {
                LOGGER.warn("Failed to resume session ({}) - it does not exist", (Object)_sessionId);
                return null;
            }
            String tenantIdStr = (String)session.getAttribute((Object)"tenant.id");
            if (null == tenantIdStr) {
                LOGGER.error("Failed to resume session ({}) - missing tenant id", (Object)_sessionId);
                return null;
            }
            try {
                ETenantContentModel contentModel;
                NobjectCollection tenantCol = ACSPersistence.getTenantsCollection();
                IONObjectId tenantId = new IONObjectId(tenantIdStr);
                Tenant tenant = (Tenant)tenantCol.get(tenantId, new ProjectionBuilder().include(new String[]{"content-version", "content-model"}).toDocument());
                if (null == tenant) {
                    LOGGER.error("Failed to resume session ({}) - invalid tenant id ({})", (Object)_sessionId, (Object)tenantIdStr);
                    return null;
                }
                Integer contentVersion = tenant.getContentVersion();
                if (contentVersion != null && !contentVersion.equals(session.getAttribute((Object)"tenant.content.version"))) {
                    session.setAttribute((Object)"tenant.content.version", (Object)contentVersion);
                }
                if ((contentModel = tenant.getContentModel()) != null && !contentModel.name().equals(session.getAttribute((Object)"tenant.content.model"))) {
                    session.setAttribute((Object)"tenant.content.model", (Object)contentModel.name());
                }
            }
            catch (PersistenceException e) {
                LOGGER.error("Failed to resume session ({}) - persistence error", (Object)_sessionId, (Object)e);
                throw new RuntimeException("Failed to resume session due to persistence error", e);
            }
            session.touch();
            if (_bind) {
                ThreadContext.bind((Subject)subject);
            }
            LOGGER.trace("Completed resuming session ({})", (Object)_sessionId);
            return subject;
        }
        catch (SessionException ex) {
            LOGGER.warn("Failed to resume session ({}) - may be invalid", (Object)_sessionId, (Object)ex);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        LOGGER.trace("Logging out current Subject");
        Subject subject = ThreadContext.unbindSubject();
        if (null != subject) {
            try {
                Session session = subject.getSession(false);
                if (null != session) {
                    session.stop();
                }
            }
            catch (SessionException sessionException) {
            }
            finally {
                subject.logout();
            }
        }
    }

    public Subject forkSubject() {
        return this.forkSubject(SecurityUtils.getSubject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject forkSubject(Subject subject) {
        Session session;
        WASubject.Builder builder = new WASubject.Builder();
        builder.authenticated(subject.isAuthenticated());
        builder.principals(subject.getPrincipals());
        builder.sessionCreationEnabled(true);
        if (subject instanceof WASubject) {
            WASubject waSubject = (WASubject)subject;
            for (String key : waSubject.getAttributeKeys()) {
                builder.attribute(key, waSubject.getAttribute(key));
            }
        }
        if (null != (session = subject.getSession(false))) {
            String newSessionId = String.format("%s_forked_%s", String.valueOf(session.getId()), UUID.randomUUID().toString());
            WASessionIdGenerator.setLocalSessionId((Serializable)((Object)newSessionId));
            try {
                WASubject newSubject = builder.buildWASubject();
                Session newSession = newSubject.getSession(true);
                for (Object key : session.getAttributeKeys()) {
                    newSession.setAttribute(key, session.getAttribute(key));
                }
                LOGGER.trace("Forked Subject and Session (principals={}, attributes={}, sessionId={})", new Object[]{newSubject.getPrincipals(), newSubject.getAttributesMap(), newSessionId});
                WASubject wASubject = newSubject;
                return wASubject;
            }
            finally {
                WASessionIdGenerator.clearLocalSessionId();
            }
        }
        WASubject newSubject = builder.buildWASubject();
        LOGGER.trace("Forked Subject (principals={}, attributes={})", (Object)newSubject.getPrincipals(), newSubject.getAttributesMap());
        return newSubject;
    }

    @Deprecated
    public IONObjectId getCurrentAccountId() {
        return ACSHelper.getCurrentAccountId();
    }

    public Account getCurrentAccount() throws PersistenceException {
        Account account = this.getAccount(ACSHelper.getCurrentAccountId());
        Assertions.assertNotNull((Object)account, (String)"account != null");
        return account;
    }

    public Account getAccount(IONObjectId _accountId) throws PersistenceException {
        if (null == _accountId) {
            throw new NullArgumentException("accountId");
        }
        NobjectCollection accountCol = ACSPersistence.getAccountsCollection();
        return (Account)accountCol.get(_accountId);
    }

    public List<Account> findAccounts(IONObject _query) throws PersistenceException {
        NobjectCollection accountCol = ACSPersistence.getAccountsCollection();
        List result = accountCol.find(_query).toListAndClose();
        return result;
    }

    public Account createAccount(String _name) throws PersistenceException {
        if (null == _name) {
            throw new NullArgumentException("name");
        }
        NobjectCollection accountCol = ACSPersistence.getAccountsCollection();
        Account account = new Account();
        account.setName(_name);
        account.setCreationDate(new Date());
        accountCol.save((Nobject)account);
        return account;
    }

    public void deleteAccount(IONObjectId _accountId) throws PersistenceException {
        if (null == _accountId) {
            throw new NullArgumentException("accountId");
        }
        NobjectCollection accountCol = ACSPersistence.getAccountsCollection();
        NobjectCollection userCol = ACSPersistence.getUsersCollection();
        NobjectCollection tenantCol = ACSPersistence.getTenantsCollection();
        NobjectCollection groupCol = ACSPersistence.getGroupsCollection();
        NobjectCollection roleCol = ACSPersistence.getRolesCollection();
        userCol.remove(new QueryBuilder().equalTo("account-id", (Object)_accountId).toDocument());
        List tenantIds = tenantCol.getDocumentCollection().findAndProject(new QueryBuilder().equalTo("account-id", (Object)_accountId).toDocument(), "_id", IONObjectId.class).toListAndClose();
        roleCol.remove(new QueryBuilder().in("tenant-id", (Collection)tenantIds).toDocument());
        tenantCol.remove(new QueryBuilder().equalTo("account-id", (Object)_accountId).toDocument());
        groupCol.remove(new QueryBuilder().equalTo("account-id", (Object)_accountId).toDocument());
        accountCol.remove(new QueryBuilder().equalTo("_id", (Object)_accountId).toDocument());
    }

    @Deprecated
    public IONObjectId getCurrentUserId() {
        return ACSHelper.getCurrentUserId();
    }

    public User getCurrentUser() throws PersistenceException {
        User user = this.getUser(ACSHelper.getCurrentUserId());
        Assertions.assertNotNull((Object)user, (String)"user != null");
        return user;
    }

    public User getUser(IONObjectId _userId) throws PersistenceException {
        if (null == _userId) {
            throw new NullArgumentException("userId");
        }
        NobjectCollection userCol = ACSPersistence.getUsersCollection();
        return (User)userCol.get(_userId);
    }

    public User getUserByExternalId(String _externalUserId) throws PersistenceException {
        if (null == _externalUserId) {
            throw new NullArgumentException("_externalUserId");
        }
        NobjectCollection userCol = ACSPersistence.getUsersCollection();
        return (User)userCol.findOne(new QueryBuilder().equalTo("external-user-id", (Object)_externalUserId).toDocument());
    }

    public Group getGroup(IONObjectId _groupId) throws PersistenceException {
        if (null == _groupId) {
            throw new NullArgumentException("groupId");
        }
        NobjectCollection groupCol = ACSPersistence.getGroupsCollection();
        return (Group)groupCol.get(_groupId);
    }

    public Role getRole(IONObjectId _roleId) throws PersistenceException {
        if (null == _roleId) {
            throw new NullArgumentException("roleId");
        }
        NobjectCollection roleCol = ACSPersistence.getRolesCollection();
        return (Role)roleCol.get(_roleId);
    }

    public List<Group> getAllGroups(UserOrGroup _userOrGroup, boolean _allAncestors) throws PersistenceException {
        IONObject queryForParentGroups = null;
        queryForParentGroups = _userOrGroup instanceof User ? new QueryBuilder().equalTo("tenant-id", (Object)_userOrGroup.getTenantId()).and(new IONObject[]{new QueryBuilder().in("members", new Object[]{_userOrGroup.getId()}).toDocument()}).toDocument() : new QueryBuilder().equalTo("tenant-id", (Object)_userOrGroup.getTenantId()).and(new IONObject[]{new QueryBuilder().in("group_members", new Object[]{_userOrGroup.getId()}).toDocument()}).toDocument();
        List<Group> groups = this.findGroups(queryForParentGroups);
        HashSet<Group> allGroups = new HashSet<Group>(groups);
        if (_allAncestors) {
            while (groups != null && groups.size() > 0) {
                ArrayList<IONObjectId> groupIds = new ArrayList<IONObjectId>();
                for (Group group : groups) {
                    groupIds.add(group.getId());
                }
                queryForParentGroups = new QueryBuilder().equalTo("tenant-id", (Object)_userOrGroup.getTenantId()).and(new IONObject[]{new QueryBuilder().in("group_members", groupIds).toDocument()}).toDocument();
                groups = this.findGroups(queryForParentGroups);
                allGroups.addAll(groups);
            }
        }
        return new ArrayList<Group>(allGroups);
    }

    public List<Role> getAllRoles(UserOrGroup _userOrGroup) throws PersistenceException {
        List<Group> allGroups = this.getAllGroups(_userOrGroup, true);
        HashSet allRolesIds = new HashSet();
        if (_userOrGroup.getRoleIds() != null) {
            allRolesIds.addAll(_userOrGroup.getRoleIds());
        }
        for (Group group : allGroups) {
            allRolesIds.addAll(group.getRoleIds());
        }
        IONObject queryForRoles = new QueryBuilder().equalTo("tenant-id", (Object)_userOrGroup.getTenantId()).and(new IONObject[]{new QueryBuilder().in("_id", allRolesIds).toDocument()}).toDocument();
        return this.findRoles(queryForRoles);
    }

    public List<User> findUsers(IONObject _query) throws PersistenceException {
        NobjectCollection userCol = ACSPersistence.getUsersCollection();
        List result = userCol.find(_query).toListAndClose();
        return result;
    }

    public List<User> findUsers(IONObject _query, IONObject _projection) throws PersistenceException {
        NobjectCollection userCol = ACSPersistence.getUsersCollection();
        List result = userCol.find(_query, _projection).toListAndClose();
        return result;
    }

    public List<Group> findGroups(IONObject _query) throws PersistenceException {
        NobjectCollection groupCol = ACSPersistence.getGroupsCollection();
        List result = groupCol.find(_query).toListAndClose();
        return result;
    }

    public List<Group> findGroups(IONObject _query, IONObject _projection) throws PersistenceException {
        NobjectCollection groupCol = ACSPersistence.getGroupsCollection();
        List result = groupCol.find(_query, _projection).toListAndClose();
        return result;
    }

    public List<Role> findRoles(IONObject _query) throws PersistenceException {
        NobjectCollection roleCol = ACSPersistence.getRolesCollection();
        List result = roleCol.find(_query).toListAndClose();
        return result;
    }

    public User createUser(IONObjectId _accountId, IONObjectId _tenantId, String _externalUserId, String _fullName, String _email, List<IONObjectId> _roleIds) throws PersistenceException {
        NobjectCollection userCol = ACSPersistence.getUsersCollection();
        User user = new User();
        user.setAccountId(_accountId);
        user.setTenantId(_tenantId);
        user.setEmail(_email);
        user.setExternalUserId(_externalUserId.toLowerCase());
        user.setFullName(_fullName);
        user.setRegisteredDate(new Date());
        user.setRoleIds(_roleIds);
        userCol.save((Nobject)user);
        return user;
    }

    public int updateUser(User _user) throws PersistenceException {
        NobjectCollection userCol = ACSPersistence.getUsersCollection();
        return userCol.update((Nobject)_user);
    }

    public int updateGroup(Group _group) throws PersistenceException {
        NobjectCollection groupCol = ACSPersistence.getGroupsCollection();
        return groupCol.update((Nobject)_group);
    }

    public void deleteUser(IONObjectId _userId) throws PersistenceException {
        if (null == _userId) {
            throw new NullArgumentException("userId");
        }
        ((UserDeleteListener)this.m_userDeleteListener.getFiringProxy()).aboutToDeleteUser(_userId.getIdentifier());
        NobjectCollection userCol = ACSPersistence.getUsersCollection();
        userCol.remove(new QueryBuilder().equalTo("_id", (Object)_userId).toDocument());
    }

    public Group createGroup(IONObjectId _accountId, IONObjectId _tenantId, String _name, List<IONObjectId> _members, List<IONObjectId> _groupMembers, List<IONObjectId> _roleIds) throws PersistenceException {
        NobjectCollection groupCol = ACSPersistence.getGroupsCollection();
        Group group = new Group();
        group.setAccountId(_accountId);
        group.setTenantId(_tenantId);
        group.setName(_name);
        group.setCreationDate(new Date());
        group.setMembers(_members);
        group.setGroupMembers(_groupMembers);
        group.setRoleIds(_roleIds);
        groupCol.save((Nobject)group);
        return group;
    }

    public void deleteGroup(IONObjectId _groupId) throws PersistenceException {
        if (null == _groupId) {
            throw new NullArgumentException("groupId");
        }
        NobjectCollection groupCol = ACSPersistence.getGroupsCollection();
        groupCol.remove(new QueryBuilder().equalTo("_id", (Object)_groupId).toDocument());
    }

    @Deprecated
    public IONObjectId getCurrentTenantId() {
        return ACSHelper.getCurrentTenantId();
    }

    public Tenant getCurrentTenant() throws PersistenceException {
        Tenant tenant = this.getTenant(ACSHelper.getCurrentTenantId());
        Assertions.assertNotNull((Object)tenant, (String)"tenant != null");
        return tenant;
    }

    public Tenant getTenant(IONObjectId _tenantId) throws PersistenceException {
        if (null == _tenantId) {
            throw new NullArgumentException("_tenantId");
        }
        NobjectCollection tenantCol = ACSPersistence.getTenantsCollection();
        return (Tenant)tenantCol.get(_tenantId);
    }

    public Tenant getTenant(String _accountName, String _tenantName) throws PersistenceException {
        if (null == _accountName) {
            throw new NullArgumentException("_accountName");
        }
        if (null == _tenantName) {
            throw new IllegalArgumentException("_tenantName");
        }
        IONObjectId accountId = (IONObjectId)ACSPersistence.getAccountsCollection().getDocumentCollection().findOneAndProject(new QueryBuilder().equalTo("name", (Object)_accountName).toDocument(), "_id", IONObjectId.class);
        if (null == accountId) {
            return null;
        }
        return (Tenant)ACSPersistence.getTenantsCollection().findOne(new QueryBuilder().equalTo("name", (Object)_tenantName).equalTo("account-id", (Object)accountId).toDocument());
    }

    public List<Tenant> findTenants(IONObject _query) throws PersistenceException {
        NobjectCollection tenantCol = ACSPersistence.getTenantsCollection();
        List result = tenantCol.find(_query).toListAndClose();
        return result;
    }

    public Tenant createTenant(IONObjectId _accountId, String _name) throws PersistenceException {
        return this.createTenant(_accountId, _name, this.m_defaultContentModel);
    }

    @Deprecated
    public Tenant createTenant(IONObjectId _accountId, String _name, IONObjectId _primaryDatabaseId, IONObjectId _backupDatabaseId) throws PersistenceException {
        return this.createTenant(_accountId, _name, this.m_defaultContentModel);
    }

    public Tenant createTenant(IONObjectId _accountId, String _name, ETenantContentModel _contentModel) throws PersistenceException {
        NobjectCollection tenantCol = ACSPersistence.getTenantsCollection();
        Tenant tenant = new Tenant();
        tenant.setAccountId(_accountId);
        tenant.setName(_name);
        tenant.setCreationDate(new Date());
        tenant.setContentVersion(Integer.valueOf(ContentVersion.CURRENT_VERSION));
        tenant.setContentModel(_contentModel);
        tenantCol.save((Nobject)tenant);
        return tenant;
    }

    @Deprecated
    public Tenant createTenant(IONObjectId _accountId, String _name, IONObjectId _primaryDatabaseId, IONObjectId _backupDatabaseId, ETenantContentModel _contentModel) throws PersistenceException {
        return this.createTenant(_accountId, _name, _contentModel);
    }

    public void deleteTenant(IONObjectId _tenantId) throws PersistenceException {
        if (null == _tenantId) {
            throw new NullArgumentException("tenantId");
        }
        NobjectCollection tenantCol = ACSPersistence.getTenantsCollection();
        NobjectCollection groupCol = ACSPersistence.getGroupsCollection();
        NobjectCollection userCol = ACSPersistence.getUsersCollection();
        NobjectCollection roleCol = ACSPersistence.getRolesCollection();
        userCol.remove(new QueryBuilder().equalTo("tenant-id", (Object)_tenantId).toDocument());
        roleCol.remove(new QueryBuilder().equalTo("tenant-id", (Object)_tenantId).toDocument());
        groupCol.remove(new QueryBuilder().equalTo("tenant-id", (Object)_tenantId).toDocument());
        tenantCol.remove(new QueryBuilder().equalTo("_id", (Object)_tenantId).toDocument());
    }

    @Deprecated
    public Map<String, List<String>> getCurrentHttpHeaders() {
        return ACSHelper.getCurrentHttpHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPostLogon(Subject _subject) {
        LOGGER.trace("Starting post-logon actions for Subject (principals={})", (Object)_subject.getPrincipals());
        String principal = _subject.getPrincipal().toString();
        if (IMPERSONATOR_PRINCIPAL.equals(principal) || NOBODY_PRINCIPAL.equals(principal)) {
            return;
        }
        if (ANONYMOUS_PRINCIPAL.equals(principal) || ANONYMOUS_TAI_USERID.equals(principal)) {
            LOGGER.trace("Mapping anonymous principal to anonymous internal id ({})", (Object)ANONYMOUS_ID.getIdentifier());
            principal = ANONYMOUS_ID.getIdentifier();
        }
        try {
            NobjectCollection userCol = ACSPersistence.getUsersCollection();
            User user = (User)userCol.findOne(new QueryBuilder().equalTo("_id", (Object)new IONObjectId(principal)).toDocument());
            if (null == user) {
                LOGGER.error("Failed to resolve user id: " + principal);
                throw new UnknownAccountException("Failed to resolve user id: " + principal);
            }
            NobjectCollection tenantCol = ACSPersistence.getTenantsCollection();
            Tenant tenant = (Tenant)tenantCol.get(user.getTenantId());
            if (null == tenant) {
                LOGGER.error("Failed to resolve tenant id: " + user.getTenantId());
                throw new UnknownAccountException("Failed to resolve tenant id: " + user.getTenantId());
            }
            NobjectCollection accountCol = ACSPersistence.getAccountsCollection();
            Account account = (Account)accountCol.get(user.getAccountId());
            if (null == account) {
                LOGGER.error("Failed to resolve account id: " + user.getAccountId());
                throw new UnknownAccountException("Failed to resolve account id: " + user.getAccountId());
            }
            Session session = _subject.getSession(true);
            session.setAttribute((Object)"user.id", (Object)user.getId().getIdentifier());
            if (user instanceof WAUser) {
                session.setAttribute((Object)"wa.user.id", (Object)((WAUser)user).getWaUserId());
            }
            session.setAttribute((Object)"user.name", (Object)user.getFullName());
            session.setAttribute((Object)"user.email", (Object)user.getEmail());
            session.setAttribute((Object)"tenant.id", (Object)tenant.getId().getIdentifier());
            if (tenant instanceof WATenant) {
                session.setAttribute((Object)"wa.tenant.id", (Object)((WATenant)tenant).getWaTenantId());
            }
            session.setAttribute((Object)"tenant.name", (Object)tenant.getName());
            session.setAttribute((Object)"account.id", (Object)account.getId().getIdentifier());
            if (account instanceof WAAccount) {
                session.setAttribute((Object)"wa.account.id", (Object)((WAAccount)account).getWaAccountId());
            }
            session.setAttribute((Object)"account.name", (Object)account.getName());
            session.setAttribute((Object)"tenant.content.version", (Object)tenant.getContentVersion());
            session.setAttribute((Object)"tenant.content.model", (Object)tenant.getContentModel().name());
            userCol.getDocumentCollection().update(user.getId(), new UpdateBuilder().push("last-logon-dates", Integer.valueOf(-2), Arrays.asList(new Date())).toDocument());
            SubjectThreadState threadState = new SubjectThreadState(_subject);
            threadState.bind();
            try {
                ((PostLogonListener)this.m_logonListener.getFiringProxy()).postLogon(_subject);
            }
            finally {
                threadState.restore();
            }
            LOGGER.trace("Completed post-logon actions for Subject (principals={})", (Object)_subject.getPrincipals());
        }
        catch (PersistenceException ex) {
            LOGGER.error("Failed post-logon actions", (Throwable)ex);
            throw new RuntimeException("An error occured while configuring the session: " + ex.toString(), ex);
        }
    }

    public Subject createSubjectForNobody() {
        return this.createSubjectForNobody(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject createSubjectForNobody(Serializable _sessionId) {
        LOGGER.info("Creating Subject for nobody (sessionId={})", (Object)_sessionId);
        SimplePrincipalCollection principals = new SimplePrincipalCollection((Object)NOBODY_PRINCIPAL, "PrivilegedRealm");
        WASubject.Builder builder = new WASubject.Builder();
        builder.principals((PrincipalCollection)principals).authenticated(true).sessionCreationEnabled(true);
        if (null != _sessionId) {
            WASessionIdGenerator.setLocalSessionId(_sessionId);
        }
        try {
            WASubject subject = builder.buildWASubject();
            Session session = subject.getSession(true);
            session.setAttribute((Object)"user.id", (Object)NOBODY_PRINCIPAL);
            session.setAttribute((Object)"wa.user.id", (Object)NOBODY_PRINCIPAL);
            session.setAttribute((Object)"user.name", (Object)NOBODY_PRINCIPAL);
            session.setAttribute((Object)"tenant.id", (Object)NOBODY_PRINCIPAL);
            session.setAttribute((Object)"wa.tenant.id", (Object)NOBODY_PRINCIPAL);
            session.setAttribute((Object)"tenant.name", (Object)NOBODY_PRINCIPAL);
            session.setAttribute((Object)"account.id", (Object)NOBODY_PRINCIPAL);
            session.setAttribute((Object)"wa.account.id", (Object)NOBODY_PRINCIPAL);
            session.setAttribute((Object)"account.name", (Object)NOBODY_PRINCIPAL);
            WASubject wASubject = subject;
            return wASubject;
        }
        finally {
            WASessionIdGenerator.clearLocalSessionId();
        }
    }

    public Subject createSubjectForTenant(IONObjectId _tenantId) throws PersistenceException {
        return this.createSubjectForTenant(_tenantId, null);
    }

    public Subject createSubjectForTenant(IONObjectId _tenantId, Serializable _sessionId) throws PersistenceException {
        NobjectCollection tenantCol = ACSPersistence.getTenantsCollection();
        Tenant tenant = (Tenant)tenantCol.get(_tenantId);
        if (null == tenant) {
            throw new UnknownAccountException("Failed to resolve tenant id: " + _tenantId);
        }
        NobjectCollection accountCol = ACSPersistence.getAccountsCollection();
        Account account = (Account)accountCol.get(tenant.getAccountId());
        if (null == account) {
            throw new UnknownAccountException("Failed to resolve account id: " + tenant.getAccountId());
        }
        return this.createSubjectForTenant(account, tenant, _sessionId);
    }

    public Subject createSubjectForTenant(Tenant _tenant) throws PersistenceException {
        return this.createSubjectForTenant(_tenant, null);
    }

    public Subject createSubjectForTenant(Tenant _tenant, Serializable _sessionId) throws PersistenceException {
        NobjectCollection accountCol = ACSPersistence.getAccountsCollection();
        Account account = (Account)accountCol.get(_tenant.getAccountId());
        if (null == account) {
            throw new UnknownAccountException("Failed to resolve account id: " + _tenant.getAccountId());
        }
        return this.createSubjectForTenant(account, _tenant, _sessionId);
    }

    public Subject createSubjectForTenant(Account _account, Tenant _tenant) {
        return this.createSubjectForTenant(_account, _tenant, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject createSubjectForTenant(Account _account, Tenant _tenant, Serializable _sessionId) {
        LOGGER.info("Creating Subject to impersonate tenant (tenantId={}, accountId={}, sessionId={})", new Object[]{_tenant.getId().getIdentifier(), _account.getId().getIdentifier(), _sessionId});
        SimplePrincipalCollection principals = new SimplePrincipalCollection((Object)IMPERSONATOR_PRINCIPAL, "PrivilegedRealm");
        WASubject.Builder builder = new WASubject.Builder();
        builder.principals((PrincipalCollection)principals).authenticated(true).sessionCreationEnabled(true);
        if (null != _sessionId) {
            WASessionIdGenerator.setLocalSessionId(_sessionId);
        }
        try {
            WASubject subject = builder.buildWASubject();
            Session session = subject.getSession(true);
            session.setAttribute((Object)"user.id", (Object)IMPERSONATOR_PRINCIPAL);
            session.setAttribute((Object)"wa.user.id", (Object)IMPERSONATOR_PRINCIPAL);
            session.setAttribute((Object)"user.name", (Object)IMPERSONATOR_PRINCIPAL);
            session.setAttribute((Object)"tenant.id", (Object)_tenant.getId().getIdentifier());
            if (_tenant instanceof WATenant) {
                session.setAttribute((Object)"wa.tenant.id", (Object)((WATenant)_tenant).getWaTenantId());
            }
            session.setAttribute((Object)"tenant.name", (Object)_tenant.getName());
            session.setAttribute((Object)"account.id", (Object)_account.getId().getIdentifier());
            if (_account instanceof WAAccount) {
                session.setAttribute((Object)"wa.account.id", (Object)((WAAccount)_account).getWaAccountId());
            }
            session.setAttribute((Object)"account.name", (Object)_account.getName());
            session.setAttribute((Object)"tenant.content.version", (Object)_tenant.getContentVersion());
            session.setAttribute((Object)"tenant.content.model", (Object)_tenant.getContentModel().name());
            WASubject wASubject = subject;
            return wASubject;
        }
        finally {
            WASessionIdGenerator.clearLocalSessionId();
        }
    }

    public Subject createSubjectForUser(Account _account, Tenant _tenant, User _user) {
        return this.createSubjectForUser(_account, _tenant, _user, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subject createSubjectForUser(Account _account, Tenant _tenant, User _user, String _sessionId) {
        LOGGER.info("Creating Subject to impersonate user (userId={}, tenantId={}, accountId={}, sessionId={})", new Object[]{_user.getId().getIdentifier(), _tenant.getId().getIdentifier(), _account.getId().getIdentifier(), _sessionId});
        SimplePrincipalCollection principals = new SimplePrincipalCollection((Object)_user.getId().getIdentifier(), "PrivilegedRealm");
        WASubject.Builder builder = new WASubject.Builder();
        builder.principals((PrincipalCollection)principals).authenticated(true).sessionCreationEnabled(true);
        if (null != _sessionId) {
            WASessionIdGenerator.setLocalSessionId((Serializable)((Object)_sessionId));
        }
        try {
            WASubject subject = builder.buildWASubject();
            Session session = subject.getSession(true);
            session.setAttribute((Object)"user.id", (Object)_user.getId().getIdentifier());
            if (_user instanceof WAUser) {
                session.setAttribute((Object)"wa.user.id", (Object)((WAUser)_user).getWaUserId());
            }
            session.setAttribute((Object)"user.name", (Object)_user.getFullName());
            session.setAttribute((Object)"user.email", (Object)_user.getFullName());
            session.setAttribute((Object)"tenant.id", (Object)_tenant.getId().getIdentifier());
            if (_tenant instanceof WATenant) {
                session.setAttribute((Object)"wa.tenant.id", (Object)((WATenant)_tenant).getWaTenantId());
            }
            session.setAttribute((Object)"tenant.name", (Object)_tenant.getName());
            session.setAttribute((Object)"account.id", (Object)_account.getId().getIdentifier());
            if (_account instanceof WAAccount) {
                session.setAttribute((Object)"wa.account.id", (Object)((WAAccount)_account).getWaAccountId());
            }
            session.setAttribute((Object)"account.name", (Object)_account.getName());
            session.setAttribute((Object)"tenant.content.version", (Object)_tenant.getContentVersion());
            session.setAttribute((Object)"tenant.content.model", (Object)_tenant.getContentModel().name());
            WASubject wASubject = subject;
            return wASubject;
        }
        finally {
            WASessionIdGenerator.clearLocalSessionId();
        }
    }

    @Deprecated
    public Subject createSubjectForSubject(Subject _subject) {
        return this.forkSubject(_subject);
    }

    private void setupAnonymous() throws PersistenceException {
        NobjectCollection userCol;
        NobjectCollection tenantCol;
        if (!this.isAnonymousAllowed()) {
            return;
        }
        NobjectCollection accountCol = ACSPersistence.getAccountsCollection();
        if (0L == accountCol.count(new QueryBuilder().equalTo("_id", (Object)ANONYMOUS_ID).toDocument())) {
            Account account = new Account();
            account.setId(ANONYMOUS_ID);
            account.setName("Anonymous");
            account.setCreationDate(new Date());
            accountCol.save((Nobject)account);
        }
        if (0L == (tenantCol = ACSPersistence.getTenantsCollection()).count(new QueryBuilder().equalTo("_id", (Object)ANONYMOUS_ID).toDocument())) {
            Tenant tenant = new Tenant();
            tenant.setId(ANONYMOUS_ID);
            tenant.setAccountId(ANONYMOUS_ID);
            tenant.setName("Anonymous");
            tenant.setContentVersion(Integer.valueOf(ContentVersion.CURRENT_VERSION));
            tenantCol.save((Nobject)tenant);
            this.ensureDefaultRoles(tenant.getId());
        }
        if (0L == (userCol = ACSPersistence.getUsersCollection()).count(new QueryBuilder().equalTo("_id", (Object)ANONYMOUS_ID).toDocument())) {
            User user = new User();
            user.setId(ANONYMOUS_ID);
            user.setFullName("Anonymous");
            user.setAccountId(ANONYMOUS_ID);
            user.setTenantId(ANONYMOUS_ID);
            user.setExternalUserId(ANONYMOUS_PRINCIPAL);
            user.setRegisteredDate(new Date());
            userCol.save((Nobject)user);
            this.ensureDefaultUserRole(user);
        }
    }

    private void ensureDefaultRoles(IONObjectId _objectId) throws PersistenceException {
        try {
            new DefaultRoleSetup(_objectId, this).ensureDefaults();
        }
        catch (GeneralPersistenceException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private void ensureDefaultUserRole(User _user) throws PersistenceException {
        MongoRoleAndCapabilityManipulator capabilityManipulator = new MongoRoleAndCapabilityManipulator(this);
        try {
            NobjectCollection roleCol = ACSPersistence.getRolesCollection();
            Role role = (Role)roleCol.findOne(new QueryBuilder().equalTo("name", (Object)"creator").equalTo("tenant-id", (Object)_user.getTenantId()).toDocument());
            capabilityManipulator.assignRoleToUser(null, role, _user);
        }
        catch (GeneralPersistenceException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public static boolean shouldCreateProReadyTenants() {
        return Boolean.parseBoolean(System.getProperty(SYS_PROP_CREATE_PRO_READY_TENANTS, DEFAULT_CREATE_PRO_READY_TENANTS));
    }
}

