/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security;

import com.ibm.neo.security.ACSHelper;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.nodel.Account;
import com.ibm.neo.security.nodel.Tenant;
import com.ibm.neo.security.nodel.User;
import com.ibm.neo.security.shiro.SessionKeepAliveHelper;
import java.util.concurrent.Callable;
import org.apache.shiro.subject.ExecutionException;
import org.apache.shiro.subject.Subject;

public class ImpersonationHelper {
    private ImpersonationHelper() {
    }

    public static <T> T callAsTenant(AccessControlService acs, Account account, Tenant tenant, Callable<T> callable) throws Throwable {
        Subject subject = acs.createSubjectForTenant(account, tenant);
        return ImpersonationHelper.callAsSubject(subject, callable);
    }

    public static <T> T callAsUser(AccessControlService acs, Account account, Tenant tenant, User user, Callable<T> callable) throws Throwable {
        Subject subject = acs.createSubjectForUser(account, tenant, user);
        return ImpersonationHelper.callAsSubject(subject, callable);
    }

    public static <T> T callAsSubject(Subject subject, Callable<T> callable) throws Throwable {
        ACSHelper.setHttpHeaders(subject, ACSHelper.getCurrentHttpHeaders());
        SessionKeepAliveHelper.getInstance().startKeepAlive(subject);
        try {
            Object object = subject.execute(callable);
            return (T)object;
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
        finally {
            SessionKeepAliveHelper.getInstance().stopKeepAlive(subject);
        }
    }
}

