/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.neo.security.capability.mongo;

import com.ibm.neo.persist.ion.IONObjectId;
import com.ibm.neo.security.AccessControlService;
import com.ibm.neo.security.capability.mongo.MongoDevopsRoleAndCapabilityManipulator;
import com.ibm.neo.security.capability.mongo.RoleAndCapabilities;
import com.ibm.neo.security.identity.CapabilityInfo;
import com.ibm.neo.security.identity.DefaultRolesAndCapabilities;
import com.ibm.neo.security.nodel.Capability;
import com.ibm.neo.security.nodel.Role;
import com.ibm.neo.security.persistence.GeneralPersistenceException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRoleSetup {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRoleSetup.class);
    private IONObjectId m_tenantId;
    private MongoDevopsRoleAndCapabilityManipulator m_capabilityManipulator;

    public DefaultRoleSetup(IONObjectId _tenantId, AccessControlService _accesscontrol) {
        this.m_tenantId = _tenantId;
        this.m_capabilityManipulator = new MongoDevopsRoleAndCapabilityManipulator(_accesscontrol);
    }

    public boolean defaultsAreCreated() {
        try {
            for (String roleName : DefaultRolesAndCapabilities.getDefaultRoles().keySet()) {
                RoleAndCapabilities persistedRole = this.m_capabilityManipulator.getRolesAndCapabilities(this.m_tenantId, roleName);
                if (persistedRole != null && persistedRole.matches(this.buildRoleAndCaps(roleName))) continue;
                return false;
            }
        }
        catch (GeneralPersistenceException generalPersistenceException) {
            // empty catch block
        }
        return true;
    }

    private void ensureCapabilities(PrintStream _out) throws GeneralPersistenceException {
        HashSet<CapabilityInfo> systemCapabilities = new HashSet<CapabilityInfo>(Arrays.asList(this.m_capabilityManipulator.listAllCapabilities()));
        Collection<CapabilityInfo> defaultCapabilityNames = this.getDefaultCapabilityInfos();
        if (systemCapabilities.size() > 0) {
            return;
        }
        this.logMessage(_out, "registering capabilities " + defaultCapabilityNames);
        this.m_capabilityManipulator.registerSystemCapabilities(DefaultRolesAndCapabilities.getDefaultCapabilities());
    }

    public void ensureDefaults() throws GeneralPersistenceException {
        this.ensureDefaults(null);
    }

    public void ensureDefaults(OutputStream _output) throws GeneralPersistenceException {
        if (this.defaultsAreCreated()) {
            return;
        }
        PrintStream out = null;
        if (_output != null) {
            out = new PrintStream(_output);
        }
        this.logMessage(out, "Default role setup for tenant " + this.m_tenantId.getIdentifier());
        this.ensureCapabilities(out);
        List<String> roles = Arrays.asList(DefaultRolesAndCapabilities.getDefaultRoles().keySet().toArray(new String[0]));
        this.logMessage(out, "registering  roles for tenant " + StringUtils.join(roles, (String)","));
        Role[] registeredRoles = this.m_capabilityManipulator.registerSystemRoles(this.m_tenantId.getIdentifier(), roles.toArray(new String[roles.size()]));
        for (String role : DefaultRolesAndCapabilities.getDefaultRoles().keySet()) {
            Object[] defaultCaps = ((Collection)DefaultRolesAndCapabilities.getDefaultRoles().get(role)).toArray(new CapabilityInfo[0]);
            this.logMessage(out, "assigning capabilities " + StringUtils.join((Object[])defaultCaps, (String)",") + " to role " + role);
            this.m_capabilityManipulator.assignCapabilitiesForRole((CapabilityInfo[])defaultCaps, this.findRoleWithName(registeredRoles, role));
        }
    }

    private Collection<CapabilityInfo> getDefaultCapabilityInfos() {
        HashSet<CapabilityInfo> defaultCapNames = new HashSet<CapabilityInfo>();
        for (CapabilityInfo capInfo : DefaultRolesAndCapabilities.getDefaultCapabilities().keySet()) {
            Collection impliedCaps = (Collection)DefaultRolesAndCapabilities.getDefaultCapabilities().get(capInfo);
            for (CapabilityInfo capabilityInfo : impliedCaps) {
                defaultCapNames.add(capabilityInfo);
            }
            defaultCapNames.add(capInfo);
        }
        return defaultCapNames;
    }

    private RoleAndCapabilities buildRoleAndCaps(String _roleName) {
        Role role = new Role(this.m_tenantId, _roleName);
        HashSet yetToExploreCaps = new HashSet();
        HashSet<CapabilityInfo> exploredCaps = new HashSet<CapabilityInfo>();
        yetToExploreCaps.addAll((Collection)DefaultRolesAndCapabilities.getDefaultRoles().get(_roleName));
        while (!yetToExploreCaps.isEmpty()) {
            ArrayList<CapabilityInfo> capsToExpand = new ArrayList<CapabilityInfo>();
            for (CapabilityInfo capability : yetToExploreCaps) {
                if (exploredCaps.contains(capability)) continue;
                exploredCaps.add(capability);
                capsToExpand.add(capability);
            }
            yetToExploreCaps.clear();
            if (capsToExpand.isEmpty()) continue;
            for (CapabilityInfo foundCap : capsToExpand) {
                yetToExploreCaps.addAll((Collection)DefaultRolesAndCapabilities.getDefaultCapabilities().get(foundCap));
            }
        }
        ArrayList<Capability> caps = new ArrayList<Capability>();
        for (CapabilityInfo capInfo : exploredCaps) {
            caps.add(new Capability(capInfo.name(), capInfo.type()));
        }
        return new RoleAndCapabilities(role, caps);
    }

    protected Role findRoleWithName(Role[] _roles, String _roleName) {
        for (Role role : _roles) {
            if (!role.getName().equals(_roleName)) continue;
            return role;
        }
        return null;
    }

    private void logMessage(PrintStream _stream, String _message) {
        if (_stream == null) {
            LOGGER.info(_message);
        } else {
            _stream.println(_message);
        }
    }
}

